<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

class WAST_Remove_Files {

	/**
	 * Remove files period
	 * @var null
	 */
	private $period;

	/**
	 * WAST_Remove_Files constructor.
	 */
	public function __construct() {
		$period       = wast_get_option( 'remove-files-period' ) ? wast_get_option( 'remove-files-period' ) * 86400 * 30 : 0;
		$this->period = time() - $period;
	}

	/**
	 * Retrieve all old ticket post id
	 * @return array|null|object
	 */
	private function get_post_ids() {
		if ( ! intval( $this->period ) ) {
			return null;
		}

		global $wpdb;

		$post_ids = $wpdb->get_results( $wpdb->prepare( "
		SELECT `post_id` FROM `$wpdb->postmeta`
		WHERE `meta_key` = '_wast_ticket_last_reply_date' 
		AND `meta_value` < %d", $this->period ) );

		$ids = array();
		if ( count( $post_ids ) ) {
			foreach ( $post_ids as $id ) {
				array_push( $ids, $id->post_id );
			}

			return $ids;
		}

		return null;
	}

	/**
	 * Retrieve all old ticket attachment files
	 * @return array|null
	 */
	private function get_ath_files() {
		$post_ids = $this->get_post_ids();
		if ( ! $post_ids ) {
			return null;
		}

		global $wpdb;

		$in = '(' . implode( ',', $post_ids ) . ')';

		$ath_files = $wpdb->get_results( "
		SELECT `meta_value` FROM `$wpdb->postmeta`
		WHERE `post_id` IN {$in} 
		AND `meta_key` = '_wast_ticket_ath_file'" );

		$files = array();
		if ( count( $ath_files ) ) {
			foreach ( $ath_files as $file ) {
				array_push( $files, $file->meta_value );
			}

			return $files;
		}

		return null;
	}

	/**
	 * Retrieve all old reply ticket
	 * @return array|null
	 */
	private function get_replies() {
		$post_ids = $this->get_post_ids();
		if ( ! $post_ids ) {
			return null;
		}

		global $wpdb;

		$in = '(' . implode( ',', $post_ids ) . ')';

		$ticket_replies = $wpdb->get_results( "
		SELECT `meta_value` FROM `$wpdb->postmeta`
		WHERE `post_id` IN {$in} 
		AND `meta_key` LIKE '_wast_ticket_reply%'" );

		$replies = array();
		if ( count( $ticket_replies ) ) {
			foreach ( $ticket_replies as $ticket_reply ) {
				$value = unserialize( $ticket_reply->meta_value );
				array_push( $replies, $value );
			}

			return $replies;
		}

		return null;
	}

	/**
	 * Retrieve all old reply ticket attachment files
	 * @return array|null
	 */
	private function get_reply_ath_files() {
		$ticket_replies = $this->get_replies();

		$ath_files = array();
		if ( $ticket_replies ) {
			foreach ( $ticket_replies as $ticket_reply ) {
				if ( array_key_exists( 'ath_file', $ticket_reply ) ) {
					array_push( $ath_files, $ticket_reply['ath_file'] );
				}
			}

			if ( count( $ath_files ) ) {
				$ath_files = array_map( function ( $value ) {
					$upload_dir = wp_upload_dir();
					$basedir    = $upload_dir['basedir'];
					$baseurl    = $upload_dir['baseurl'];

					return str_replace( $baseurl, $basedir, $value );
				}, $ath_files );

	foreach ($ath_files as $file) {
    // دریافت اطلاعات مسیر فایل
    $pathinfo = pathinfo($file);

    // استخراج dirname، filename و extension
    $dirname  = isset($pathinfo['dirname']) ? $pathinfo['dirname'] : '';
    $filename = isset($pathinfo['filename']) ? $pathinfo['filename'] : '';
    $extension = isset($pathinfo['extension']) ? $pathinfo['extension'] : '';

    // ایجاد الگوی جستجو
    $pattern = $dirname . DIRECTORY_SEPARATOR . $filename . "-*." . $extension;


					// add cropped images
					$cropped_files = glob( $pattern );
					if ( sizeof( $cropped_files ) ) {
						foreach ( $cropped_files as $cropped_file ) {
							array_push( $ath_files, $cropped_file );
						}
					}
				}

				return $ath_files;
			}

			return null;
		}

		return null;
	}

	/**
	 * Retrieve all old files
	 * @return array
	 */
	public function get_all_files() {
		$files = array();

		if ( $this->get_ath_files() ) {
			foreach ( $this->get_ath_files() as $file ) {
				if ( file_exists( $file ) ) {
					array_push( $files, $file );
				}
			}
		}
		if ( $this->get_reply_ath_files() ) {
			foreach ( $this->get_reply_ath_files() as $file ) {
				if ( file_exists( $file ) ) {
					array_push( $files, $file );
				}
			}
		}

		return $files;
	}

	/**
	 * Delete old meta field
	 */
	public function delete_meta() {
		$post_ids = $this->get_post_ids();
		if ( ! $post_ids ) {
			return;
		}
		foreach ( $post_ids as $post_id ) {
			delete_post_meta( $post_id, '_wast_ticket_ath_file' );
		}

		// TODO: remove ath_file key from meta_value form _wast_ticket_reply
	}

	/**
	 * Remove old files
	 */
	public function remove_files() {
		$ath_files = $this->get_ath_files();
		if ( $ath_files ) {
			foreach ( $ath_files as $ath_file ) {
				@unlink( $ath_file );
			}
		}

		$reply_ath_files = $this->get_reply_ath_files();
		if ( $reply_ath_files ) {
			foreach ( $reply_ath_files as $reply_ath_file ) {
				@unlink( $reply_ath_file );
			}
		}
	}
}