<?php
namespace Elementor;

class blogthree extends Widget_Base {
	
	public function get_name() {
		return 'blogthree';
	}
	
	public function get_title() {
		return 'وبلاگ - تمام مطالب';
	}
	
	
    public function get_icon() {
		return 'eicon eicon-posts-group';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }
	protected function register_controls() {

		$post_cat = array();
		$categories = get_terms("category");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		


		
		$this->add_control(
			'title',
			[
				'label' => 'عنوان',
				'label_block' => true,
				'default' => 'مطالب',
				'type' => Controls_Manager::TEXT,
				'placeholder' => 'عنوان را وارد نمایید',
			]
		);

		
		
		$this->add_control(
			'title2',
			[
				'label' => 'عداد مطالب',
				'label_block' => true,
				'default' => '9',
				'type' => Controls_Manager::TEXT,
				'placeholder' => 'یک عدد وارد کنید',
			]
		);


	$this->end_controls_section();
	}
	
	protected function render() {
		
		 $settings = $this->get_settings_for_display();

        $title2 = $settings['title2'];
     
		
		include  'blog.php';
	}
	
	protected function _content_template() {

    }
	
	
}