<?php
namespace Elementor;

class wpp1 extends Widget_Base {
	
	public function get_name() {
		return 'wpp1';
	}
	
	public function get_title() {
		return 'اسلایدر مطالب 2';
	}
	
  public function get_icon() {
		return 'eicon eicon-post-content';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }
	
	protected function register_controls() {

		$post_cat = array();
		$categories = get_terms("category");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		


		
		$this->add_control(
			'title',
			[
				'label' => 'عنوان',
				'label_block' => true,
				'default' => 'مطالب',
				'type' => Controls_Manager::TEXT,
				'placeholder' => 'عنوان را وارد نمایید',
			]
		);

		$this->add_control(
			'post_sort',
			[
				'label' => 'مرتب سازی مطالب',
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => 'آخرین مطالب',
					'random' => 'مطالب تصادفی',
					'viewed' => 'مطالب پربازدید',
				],
			]
		);

		$this->add_control(
			'post_cat',
			[
				'label' => 'دسته بندی مطالب',
				'type' => Controls_Manager::SELECT2,
				'options' => $post_cat,
			]
		);




		$this->add_control(
			'ptotalcount',
			[
				'label' => 'تعداد مطالب',
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 20,
				'step' => 1,
				'default' => 8,
			]
		);


		$this->end_controls_section();
		
		
        	       $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );

		
	

       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش نویسنده', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		       $this->add_control(
			'farnamoneshow3',
			[
				'label' => __( 'نمایش تاریخ', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		

		         $this->add_control(
			'farnamoneshow4',
			[
				'label' => __( 'عنوان', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
		'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
			'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		    
		
        $this->end_controls_section();


        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             



		   
		   $this->add_control(
'color_farnam_2',
			[
				'label' => __( 'رنگ پس زمینه ایکون نویسنده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .list-meta-133334 i' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   	   $this->add_control(
'color_farnam_3',
			[
				'label' => __( 'رنگ ایکون نویسنده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .list-meta-133334 i' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   	   $this->add_control(
'color_farnam_4',
			[
				'label' => __( 'رنگ نویسنده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .list-meta-133334 h5' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
	   
		   	   $this->add_control(
'color_farnam_5',
			[
				'label' => __( 'رنگ ایکون تاریخ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .list-meta-2445435 i' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		      	   $this->add_control(
'color_farnam_6',
			[
				'label' => __( 'رنگ تاریخ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .list-meta-2445435' => 'color: {{VALUE}} !important',
				],
			]
           );
		   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی دور مطالب', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .product-list-1234234' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
				  $this->add_responsive_control(
                        'farnamborder3',
                        [
                            'label' => esc_html__( 'گردی دور تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .product-list-1234234 img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
								
				  $this->add_responsive_control(
                        'farnamborder4',
                        [
                            'label' => esc_html__( 'گردی دور ایکون نویسنده', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .list-meta-133334 i' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
			
        $this->end_controls_section();


	}
	
	protected function render() {
		global $az_data;
		$settings = $this->get_settings_for_display();
		$post_cat = $settings['post_cat']; ?>
        <div class="rcon">
			<div class="post-block m-product ir99">
		
			<?php
			$post_sort = $settings['post_sort'];
				switch ($post_sort) {
					case 'latest':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
						break;
					case 'viewed':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'meta_key' => 'post_views_count',
						'orderby' => 'meta_value_num',
						'order' => 'DESC'  );
						break;
					case 'random':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'orderby'        => 'rand'  );
						break;
					default:
					$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
					}
					if ( $post_cat ) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'category',
							'field' => 'term_id',
							'terms' => $post_cat
							)
						);
					}
				$postsquery = new \WP_Query( $args );
			?>
			
			<?php if ( $postsquery->have_posts() ) { ?>
			<script>
			   $(document).ready(function(){
$('.owl-blog').owlCarousel({
    loop:true,
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
	dots:true,
        margin:10,
    dots: false,
    responsive:{
        0:{
            items:1
        },
        600:{
            items:3
        },
        1200:{
            items:4
        }
    }
})
});
</script>
		                   <div class="owl-blog owl-carousel bxboxone">

			<?php while ( $postsquery->have_posts() ) : $postsquery->the_post(); ?>
<div class="product-list234234 try4554g4gr">
<div class="product-list-1234234 gffhrttrh-5445tgg">

<a  href="<?php the_permalink(); ?>">
	<?php the_post_thumbnail(''); ?><?php if ( 'yes' === $settings['farnamoneshow4'] ) { ?>
<h3><?php the_title(); ?></h3><?php }
						
					?> 
</a>

<div class="list-meta">
 <?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>

<span class="list-meta-133334">
<i class="fi fi-rr-user kkks-name-user"></i>
<h5><?php echo get_the_author_meta('display_name'); ?> </h5>

</span><?php }
						
					?> <?php if ( 'yes' === $settings['farnamoneshow3'] ) { ?>

<span class="list-meta-2445435">
 <i class="fi fi-rr-hourglass-end"></i> 
<?php the_time('d M Y'); ?>
</span><?php }
						
					?> 
</div>
</div></div>
			<?php endwhile; ?>
				</div>
			<?php 
			} else {		
			echo 'لطفا ابتدا نوشته ای را اضافه نمایید.';}
			wp_reset_postdata();
			?>
			</div>
   		</div>
        <?php

	}

}