<?php
namespace Elementor;

class wcategorythree extends Widget_Base {
	
	public function get_name() {
		return 'wcategorythree';
	}
	
	public function get_title() {
		return 'فرنام - دسته 3';
	}
	
	public function get_icon() {
		return 'fa fa-facebook';
	}
	
	public function get_categories() {
		return [ 'basic' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);

				$this->add_control(
			'link',
			[
				'label' => __( 'لینک دسته بندی', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'ادرس لینک را وارد کنید', 'elementor' ),
			]
		);

$this->add_control(
			'color',
			[
				'label' => __( 'رنگ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'image',
			[
				'label' => __( 'تصویر دسته بندی', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(

			'code',
			[
				'label' => __( 'تعداد محصولات', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'مثلا 13', 'elementor' ),
			]
		);
$this->add_control(
			'icon',
			[
				'label' => __( 'ایکون', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
	$this->add_control(

			'codeone',
			[
				'label' => __( 'کد دسته بندی', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'مثلا d45', 'elementor' ),
			]
		);
		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
			echo "
			
			<a href='$settings[link]' class='iran-cat-9-fd'>
			";
					echo '<div class="iran-farnam-9-aks-32" style="background: url(' . $settings['image']['url'] . ');"></div>
';
echo "
<style>
.iran-farnam-9-box-iner.$settings[codeone]::after , .iran-farnam-9-box-iner.$settings[codeone]::before {
	background: $settings[color];

</style>
<div class='iran-farnam-9-box-iner $settings[codeone]' style='background: $settings[color]'>
<h4>$settings[title]</h4>
	<div class='chakame-123-d' style='color: $settings[color]'>	
";


		?>
	<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?></div>
	
		<?php

echo "


<p>

لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی
</p>
</div>			
	</a>
		";
			

	

	}


	
	protected function _content_template() {

    }
	
	
}