<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class poff2 extends Widget_Base {

    public function get_name() {
        return 'poff2';
    }
    
    public function get_title() {
        return __( 'محصولات شگفت انگیز 2', 'woolentor' );
    }

   public function get_icon() {
		return 'eicon eicon-bag-medium';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }

    public function get_script_depends() {
        return [
            'woolentor-widgets-scripts',
            'slick',
        ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'woolentor-products',
            [
                'label' => esc_html__( 'تنظیمات محصول', 'woolentor' ),
            ]
        );
        
            

            $this->add_control(
                'woolentor_product_grid_product_filter',
                [
                    'label' => esc_html__( 'فیلتر شده', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'recent',
                    'options' => [
                        'recent' => esc_html__( 'آخرین محصولات', 'woolentor' ),
                        'featured' => esc_html__( 'محضولات ویژه', 'woolentor' ),
                        'best_selling' => esc_html__( 'محصولات پر فروش', 'woolentor' ),
                        'sale' => esc_html__( 'محصولات تخفیفی', 'woolentor' ),
                        'top_rated' => esc_html__( 'محصولات محبوب', 'woolentor' ),
                    ],
                ]
            );
           
            $this->add_control(
              'woolentor_product_grid_row',
              [
                 'label'   => __( 'ستون ( فعلا فقط ۱ )', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 1,
                 'min'     => 1,
                 'max'     => 20,
                 'step'    => 1,
              ]
            );

            $this->add_control(
              'woolentor_product_grid_products_count',
              [
                 'label'   => __( 'تعداد محصولات', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 4,
                 'min'     => 1,
                 'max'     => 100,
                 'step'    => 1,
              ]
            );

            $this->add_control(
                'woolentor_product_grid_categories',
                [
                    'label' => esc_html__( 'دسته بندی محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => woolentor_woocommerce_product_categories(),
                ]
            );
           

           

        $this->end_controls_section();


             $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );

		


       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش تایمر', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		      $this->add_control(
			'farnamoneshow3',
			[
				'label' => __( 'نمایش عنوان انگلیسی', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
			      $this->add_control(
			'farnamoneshow4',
			[
				'label' => __( 'نمایش درصد فروش', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
			      $this->add_control(
			'farnamoneshow5',
			[
				'label' => __( 'نمایش ویژگی ها', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
			      $this->add_control(
			'farnamoneshow6',
			[
				'label' => __( 'نمایش زمان تحویل', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
        $this->end_controls_section();


        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             


$this->add_control(
'color_farnam_1',
			[
				'label' => __( 'رنگ پس زمینه درصد تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .darsad' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'color_farnam_2',
			[
				'label' => __( 'رنگ متن درصد تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .darsad' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'color_farnam_3',
			[
				'label' => __( 'رنگ نوار درصد فروش', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .progress-bar-bamdad' => 'background: {{VALUE}} !important',
				],
			]
           );

		   $this->add_control(
'color_farnam_4',
			[
				'label' => __( 'رنگ درصد فروش', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .bamdad-darsad' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   		   $this->add_control(
'color_farnam_5',
			[
				'label' => __( 'رنگ کادر اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .product-style.htpp.ir-owl.offer-00-1' => 'border-color: {{VALUE}} !important',
				],
			]
           );
		   		   		   $this->add_control(
'color_farnam_6',
			[
				'label' => __( 'رنگ پس زمینه عنوان اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .product-style.htpp.ir-owl.offer-00-1::before' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   		   		   		   $this->add_control(
'color_farnam_7',
			[
				'label' => __( 'رنگ متن عنوان اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .product-style.htpp.ir-owl.offer-00-1::before' => 'color: {{VALUE}} !important',
				],
			]
           );
		   	   		   		   		   $this->add_control(
'color_farnam_8',
			[
				'label' => __( 'رنگ کادر thumb', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} 	#thumbs .current .item-thumbin ' => 'border-color: {{VALUE}} !important',
				],
			]
           );
		   
		   	   	   		   		   		   $this->add_control(
'color_farnam_9',
			[
				'label' => __( 'رنگ پس زمینه ثانیه شمار', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} 	.mini-1-time ' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   		   	   	   		   		   		   $this->add_control(
'color_farnam_10',
			[
				'label' => __( 'رنگ متن ثانیه شمار', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} 	.mini-1-time ' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   		   	   	   		   		   		   $this->add_control(
'color_farnam_11',
			[
				'label' => __( 'رنگ پس زمینه زمان تحویل', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}}  .meta-rasmi-2 ' => 'background: {{VALUE}} !important',
				],
			]
           );
		   		   		   	   	   		   		   		   $this->add_control(
'color_farnam_12',
			[
				'label' => __( 'رنگ متن زمان تحویل', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
		
				'selectors' => [
					'{{WRAPPER}}  .meta-rasmi-2 ' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .product-style.htpp.ir-owl.offer-00-1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

  $this->add_responsive_control(
                        'farnamborder2',
                        [
                            'label' => esc_html__( 'گردی thumb', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} #thumbs .current .item-thumbin' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
				  $this->add_responsive_control(
                        'farnamborder3',
                        [
                            'label' => esc_html__( 'گردی زمان تحویل', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .meta-rasmi-2' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
						
									  $this->add_responsive_control(
                        'farnamborder4',
                        [
                            'label' => esc_html__( 'گردی درصد تخفیف', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .darsad' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
						
						
								  $this->add_responsive_control(
                        'farnamborder5',
                        [
                            'label' => esc_html__( 'گردی درصد فروش', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .ee499 .bamdad-darsad' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					
								  $this->add_responsive_control(
                        'farnamborder6',
                        [
                            'label' => esc_html__( 'گردی تایمر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .time1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					
									  $this->add_responsive_control(
                        'farnamborder7',
                        [
                            'label' => esc_html__( 'گردی عنوان', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .product-style.htpp.ir-owl.offer-00-1::before' => 'border-radius: 0px 0px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
        $this->end_controls_section();

             


          



    }

    protected function render( $instance = [] ) {

        $settings           = $this->get_settings_for_display();
        $product_type       = $this->get_settings_for_display('woolentor_product_grid_product_filter');
        $per_page           = $this->get_settings_for_display('woolentor_product_grid_products_count');
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $order              = $this->get_settings_for_display('order');
        $columns            = $this->get_settings_for_display('woolentor_product_grid_column');
        $rows               = $this->get_settings_for_display('woolentor_product_grid_row');
        $tabuniqid          = $this->get_id();
        $proslider          = $this->get_settings_for_display('proslider');
        $producttab          = $this->get_settings_for_display('producttab');

        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $slider_settings = [
  
        ];

        $slider_responsive_settings = [
     

        ];

        $slider_settings = array_merge($slider_settings, $slider_responsive_settings);

        // WooCommerce Category
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $per_page,
        );

        switch( $product_type ){

            case 'sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
            break;

            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;

            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'top_rated': 
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';          
            break;

            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;

            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby'] = $orderby;
            $args['order'] = $order;
        }

        $get_product_categories = $settings['woolentor_product_grid_categories']; // get custom field value
        $product_cats = str_replace(' ', '', $get_product_categories);

        if ( "0" != $get_product_categories) {
            if( is_array($product_cats) && count($product_cats) > 0 ){
                $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_cat',
                        'terms' => $product_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }

        $products = new \WP_Query( $args );

        $tabmenu = 'yes';

        if( ($proslider == 'yes') && ( $producttab != 'yes' ) ){
            $collumval = 'slide-item ht-col-xs-12';
        }else{
            $collumval = 'product-list';
            if( $columns !='' ){
                if( $columns == 5){
                    $collumval = 'product-list';
                }else{
                    $colwidth = round(12/$columns);
                    $collumval = 'ht-col-lg-'.$colwidth.'product-list';
                }
            }
        }

        ?>
          
        <div class="product-style htpp ir-owl offer-00-1">

            <?php if ( $producttab == 'yes' ) { ?>
                <div class="product-tab-list ht-text-center">
  
                    </ul>
                </div>
            <?php }; ?>

            <?php if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ): ?>
                
            <?php
                $j=0;
                foreach( $product_cats as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    $products = new \WP_Query( $args );
                    ?>
                
                <?php endforeach;?>

            <?php else:?>
                <div class="ht-row ertert">
                 <script>
				 $(document).ready(function() {
  var bigimage = $("#big");
  var thumbs = $("#thumbs");
  //var totalslides = 10;
  var syncedSecondary = true;

  bigimage
    .owlCarousel({
    items: 1,
	  autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
	rtl: true,
    nav: false,
    dots: false,
    loop: true,
    responsiveRefreshRate: 200,
    navText: [
      '<i class="fa fa-arrow-left" aria-hidden="true"></i>',
      '<i class="fa fa-arrow-right" aria-hidden="true"></i>'
    ]
  })
    .on("changed.owl.carousel", syncPosition);

  thumbs
    .on("initialized.owl.carousel", function() {
    thumbs
      .find(".owl-item")
      .eq(0)
      .addClass("current");
  })
    .owlCarousel({
    items: 6,
    dots: true,
    nav: true,
    navText: [
      '<i class="fa fa-arrow-left" aria-hidden="true"></i>',
      '<i class="fa fa-arrow-right" aria-hidden="true"></i>'
    ],
    smartSpeed: 200,
    slideSpeed: 500,
    slideBy: 6,
    responsiveRefreshRate: 100
  })
    .on("changed.owl.carousel", syncPosition2);

  function syncPosition(el) {
    //if loop is set to false, then you have to uncomment the next line
    //var current = el.item.index;

    //to disable loop, comment this block
    var count = el.item.count - 1;
    var current = Math.round(el.item.index - el.item.count / 2 - 0.5);

    if (current < 0) {
      current = count;
    }
    if (current > count) {
      current = 0;
    }
    //to this
    thumbs
      .find(".owl-item")
      .removeClass("current")
      .eq(current)
      .addClass("current");
    var onscreen = thumbs.find(".owl-item.active").length - 1;
    var start = thumbs
    .find(".owl-item.active")
    .first()
    .index();
    var end = thumbs
    .find(".owl-item.active")
    .last()
    .index();

    if (current > end) {
      thumbs.data("owl.carousel").to(current, 100, true);
    }
    if (current < start) {
      thumbs.data("owl.carousel").to(current - onscreen, 100, true);
    }
  }

  function syncPosition2(el) {
    if (syncedSecondary) {
      var number = el.item.index;
      bigimage.data("owl.carousel").to(number, 100, true);
    }
  }

  thumbs.on("click", ".owl-item", function(e) {
    e.preventDefault();
    var number = $(this).index();
    bigimage.data("owl.carousel").to(number, 300, true);
  });
});

</script>
   <div id="big" class="owl-carousel owl-theme">

                        <div class="<?php echo esc_attr( $collumval );?>">
                            <?php
                                $k=1;
                                if( $products->have_posts() ):
                                    while( $products->have_posts() ): $products->the_post();
                            ?>
<div class="slide-13-ded">
<div class="sdfds-3w4">
<a href="<?php the_permalink(); ?>">
  	<?php the_post_thumbnail('woocommerce_thumbnail'); ?>
	
	
	</a>
			 <?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>

	
<?php global $product;
								if(  $product->is_on_sale() && $product->is_type('variable')){
?>
							<?php
				    global $post;
 // Variation ID
   $date="";
		    $sc_saving_pric = "";
			$sc_english_format_number = "";
            foreach($product->get_available_variations() as $variation ){
            $variation_id = $variation['variation_id'];
			            $sales_price_tot = get_post_meta( $variation_id, '_sale_price_dates_to', true );

								if(  $product->is_on_sale() && $sales_price_tot != "" && $product->is_type('variable')){
									
									
     
					?>
<?php global $post;

if ( ! $available_variations ) {
?>

	<?php
						if( $product->is_on_sale() && ! is_admin() && ! $product->is_type('variable')){
										$available_variations = $product->get_available_variations();

						}
		elseif($product->is_type('variable')){
		    $date="";
		    $sc_saving_pric = "";
			$sc_english_format_number = "";
            foreach($product->get_available_variations() as $variation ){
            // Variation ID
            $variation_id = $variation['variation_id'];
        // Prices
        $active_price = floatval($variation['display_price']); // Active price
        $regular_price = floatval($variation['display_regular_price']); // Regular Price
        if( $active_price != $regular_price ){
            $sale_price = $active_price; // Sale Price

            $meta_date = get_post_meta( $variation_id, '_sale_price_dates_to', true );
 $date1  .= 'display: block;';
            $sc_saving_pric .= $regular_price - $active_price;
			$sc_english_format_number .= number_format($sc_saving_pric);
        }





        }
						}
						
						  global $product;
	
		 
    if( $product->is_type('variable') ){
        $default_attributes = $product->get_default_attributes();
        foreach($product->get_available_variations() as $variation_values ){
            foreach($variation_values['attributes'] as $key => $attribute_value ){
                $attribute_name = str_replace( 'attribute_', '', $key );
                $default_value = $product->get_variation_default_attribute($attribute_name);
                if( $default_value == $attribute_value ){
                    $is_default_variation = true;
                } else {
                    $is_default_variation = false;
                    break; // Stop this loop to start next main lopp
                }
            }
            if( $is_default_variation ){
                $variation_id = $variation_values['variation_id'];
                break; // Stop the main loop
		
            }
        }
		
		
        if( $is_default_variation ){
            // Raw output of available "default" variation details data
		 $meta_date = get_post_meta( $variation_id, '_sale_price_dates_to', true );
					if( empty( $meta_date ) ){
																//	echo esc_html_e( 'زمان بندی پیشنهاد ویژه تعیین نشده است!', 'studiare' );
															}
          	else{
					$date  = date( 'm/d/Y', $meta_date );//echo $date;
			}
		
								if( empty( $meta_date ) ){
								}
								else{
	
						   ?>
						   


<div class="iran-pak in-offer-2 rgggfgff timer-hazfi99">
<div id="fm2<?php echo get_the_ID(); ?>"></div>
<script type="text/javascript">
 $('#fm2<?php echo get_the_ID(); ?>').countdown('<?php echo esc_attr( $date ) ?>', function(event) {
  var $this = $(this).html(event.strftime(''
    + '<div class="timer-wrapper"><div class="time1">%D</div><span class="text32">روز</span></div>'
    + '<div class="timer-wrapper"><div class="time1">%H</div><span class="text32">ساعت</span></div>'
    + '<div class="timer-wrapper"><div class="time1">%M</div><span class="text32">دقیقه</span></div>'
    + '<div class="timer-wrapper"><div class="time1 mini-1-time">%S</div><span class="text32">ثانیه</span></div>'
));
});
</script>

</div>
<?php }
			}
								}	}	}}}
					?>
					
					
					
					
  <?php
					global $post;

  $sales_price_to = get_post_meta($post->ID, '_sale_price_dates_to', true);
  

    if (  $sales_price_to != "" ) {      


 
					?>	<div class="iran-pak in-offer-2 rgggfgff">
<div id="fm2<?php echo get_the_ID(); ?>"></div>
<script type="text/javascript">
 $('#fm2<?php echo get_the_ID(); ?>').countdown('<?php echo do_shortcode( '[display_end_date]' ); ?>', function(event) {
  var $this = $(this).html(event.strftime(''
    + '<div class="timer-wrapper"><div class="time1">%D</div><span class="text32">روز</span></div>'
    + '<div class="timer-wrapper"><div class="time1">%H</div><span class="text32">ساعت</span></div>'
    + '<div class="timer-wrapper"><div class="time1">%M</div><span class="text32">دقیقه</span></div>'
    + '<div class="timer-wrapper"><div class="time1 mini-1-time">%S</div><span class="text32">ثانیه</span></div>'
));
});
</script>

</div>
<?php }
					
					?><?php }
					
					?>
</div>

<div class="nesf-50">
<a href="<?php the_permalink(); ?>">

<h3> <?php the_title(); ?></h3></a>
 <?php if ( 'yes' === $settings['farnamoneshow3'] ) { ?>

  <?php $option_meta = rwmb_meta('title-1'); if (!empty($option_meta)) { ?>
<p><?php echo $option_meta; ?></p>

<?php } ?>
<?php } ?>
 <?php if ( 'yes' === $settings['farnamoneshow4'] ) { ?>

<div class="ee499">
				<?php farnam_stock_progress_bar(); ?>
</div><?php } ?>
 <?php if ( 'yes' === $settings['farnamoneshow5'] ) { ?>

<?php $option_meta = rwmb_meta('wysiwyg_1'); if (!empty($option_meta)) { ?>


<div class="vijegi fff333ff">
<?php echo $option_meta; ?>

</div>
<?php } ?><?php } ?>

<div class="mroce">

<div class="proce ggg54t4554g">

<span class="list-meta-2">
<?php global $product; if( $product->is_on_sale() ) { ?>

<div class="darsad">
	<?php echo apply_filters( 'woocommerce_sale_flashtwo', $post, $product ); ?>


</div>
<?php } ?>
<?php global $product; echo $product->get_price_html(); ?>
</span>

</div>

<div class="noose">
 <?php if ( 'yes' === $settings['farnamoneshow6'] ) { ?>

<?php $option_meta = rwmb_meta('had'); if (!empty($option_meta)) { ?>
<div class="box-rasmi-meta">
<div class="meta-rasmi-1"><div class="meta-rasmi-2">  <i class="mdi mdi-timer-sand"></i>تحویل تا 
<?php echo $option_meta; ?>
روز دیگر</div></div>
</div>
<?php } ?> <?php } ?>

</div>


</div>

</div>


</div>

                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
							
                            <div class="<?php echo esc_attr($collumval );?>">
                                <?php } $k++; endwhile; wp_reset_postdata();  endif; ?>
								
                            </div>
							
                    <?php if( $proslider == 'yes' ){ echo '</div>';} ?>
                </div>       </div>
            <?php endif;?>
 <?php if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ): ?>
                
            <?php
                $j=0;
                foreach( $product_cats as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    $products = new \WP_Query( $args );
                    ?>
                
                <?php endforeach;?>

            <?php else:?>


<div id="thumbs" class="owl-carousel owl-theme">

                        <div class="<?php echo esc_attr( $collumval );?>">
                            <?php
                                $k=1;
                                if( $products->have_posts() ):
                                    while( $products->have_posts() ): $products->the_post();
                            ?>
  <div class="item-thumbin">
  	<?php the_post_thumbnail('thumbnail'); ?>
<h3> <?php the_title(); ?></h3>  </div>
</div>

 
                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                         
							
                            <div class="<?php echo esc_attr($collumval );?>">
                                <?php } $k++; endwhile; wp_reset_postdata();  endif; ?>
								
                            </div>
							
                    <?php if( $proslider == 'yes' ){ echo '</div>';} ?>
    <?php endif;?>
        </div>  


        <?php

    }


}



