<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}


// License page function
function efa_2710_license_page(): void {
    $plugin_url = plugin_dir_url(dirname(__FILE__));
    
    // Enqueue WordPress core CSS
    wp_enqueue_style('dashicons');
    ?>
    <div class="wrap persian-elementor-settings">
        <style>
            /* Include the same CSS as in the main settings page */
            .persian-elementor-settings {
                max-width: 1200px;
                margin: 0 auto;
                padding: 20px;
                font-family: IRANYekanXVF, Tahoma, Arial, sans-serif;
            }
            .persian-elementor-header {
                display: flex;
                align-items: center;
                margin-bottom: 25px;
                background: linear-gradient(135deg, #b74573 0%, #940040 100%);
                border-radius: 8px;
                padding: 20px;
                color: #fff;
                box-shadow: 0 4px 6px rgba(50, 50, 93, 0.11), 0 1px 3px rgba(0, 0, 0, 0.08);
                flex-wrap: wrap;
            }
            .persian-elementor-header-main {
                display: flex;
                align-items: center;
                width: 100%;
                margin-bottom: 15px;
            }
            .persian-elementor-header-title {
                display: flex;
                flex-direction: column;
            }
            .persian-elementor-header h1 {
                color: white;
                margin: 0;
                font-size: 24px;
                font-weight: bold;
            }
            .persian-elementor-header h2 {
                color: rgba(255, 255, 255, 0.9);
                margin: 5px 0 0;
                font-size: 16px;
                font-weight: normal;
                font-size: 22px;
                font-family: 'IRANYekanX';
            }
            .persian-elementor-header p {
                color: rgba(255, 255, 255, 0.9);
                line-height: 1.6;
                margin: 5px 0 0;
                font-size: 14px;
            }
            .persian-elementor-logo {
                margin-left: 20px;
                background: white;
                padding: 10px;
                border-radius: 8px;
                box-shadow: 0 4px 6px rgba(50, 50, 93, 0.11), 0 1px 3px rgba(0, 0, 0, 0.08);
            }
            .persian-elementor-logo img {
                width: 60px;
                height: 60px;
                display: block;
            }
            .persian-elementor-card {
                background: #fff;
                border-radius: 8px;
                box-shadow: 0 1px 3px rgba(0, 0, 0, 0.12), 0 1px 2px rgba(0, 0, 0, 0.24);
                margin: 20px 0px;
                overflow: hidden;
            }
            .persian-elementor-card-header {
                padding: 15px 20px;
                background: #f8f9fa;
                border-bottom: 1px solid #edf2f7;
            }
            .persian-elementor-card-header h2 {
                margin: 0;
                color: #4a5568;
                font-size: 16px;
                font-weight: bold;
                font-family: 'IRANYekanX';
            }
            .persian-elementor-card-body {
                padding: 20px;
            }
            
            /* License specific styles */
            .wrap-license-efa {
                background: transparent;
                margin: 0;
                padding: 0;
                width: 100%;
                box-shadow: none;
                border-radius: 0;
            }
            .wrap-license-efa .pluginname {
                color: #4a5568;
                font-weight: bold;
                margin-top: 0;
            }
            .wrap-license-efa input[type="password"],
            .wrap-license-efa input[type="text"] {
                width: 100%;
                max-width: 400px;
                padding: 8px 12px;
                border-radius: 4px;
                border: 1px solid #e2e8f0;
            }
            .wrap-license-efa .button-secondary,
            .wrap-license-efa input[type="submit"] {
                background: #05047e;
                color: white;
                border: none;
                padding: 10px 20px;
                font-size: 14px;
                font-weight: bold;
                border-radius: 4px;
                cursor: pointer;
                transition: all 0.3s ease;
                box-shadow: 0 1px 3px rgba(0, 0, 0, 0.12), 0 1px 2px rgba(0, 0, 0, 0.24);
                text-decoration: none;
                display: inline-block;
                line-height: 1;
            }
            .wrap-license-efa .button-secondary:hover,
            .wrap-license-efa input[type="submit"]:hover {
                background: #5454bd;
                transform: translateY(-2px);
                box-shadow: 0 7px 14px rgba(50, 50, 93, 0.1), 0 3px 6px rgba(0, 0, 0, 0.08);
            }
            .wrap-license-efa th {
                text-align: right;
                padding: 15px 0;
                font-weight: bold;
            }
            .wrap-license-efa td {
                padding: 10px 0;
            }
            .wrap-license-efa .form-table {
                width: 100%;
            }
			.notice {
			display:none!important
			}
        </style>

        <div class="persian-elementor-header">
            <div class="persian-elementor-header-main">

                <div class="persian-elementor-header-title">
                    <h2><?php echo (get_locale() === 'fa_IR') ? 'لایسنس المنتور پرو' : 'Elementor Pro License'; ?></h2>
                </div>
            </div>
            <p>
                <?php echo (get_locale() === 'fa_IR') 
                    ? 'در این صفحه می‌توانید لایسنس خود را برای استفاده از تمام امکانات المنتور پرو وارد و فعال کنید.'
                    : 'On this page, you can enter and activate your license to use all Elementor Pro features.'; ?>
            </p>
        </div>

        <div class="persian-elementor-card">
            <div class="persian-elementor-card-header">
                <h2><?php echo (get_locale() === 'fa_IR') ? 'مدیریت لایسنس' : 'License Management'; ?></h2>
            </div>
            <div class="persian-elementor-card-body">
                <?php
                if (function_exists('efa_2710_func_license')) {
                    efa_2710_func_license();
                } else {
                    echo '<div class="notice notice-error"><p>';
                    echo (get_locale() === 'fa_IR') 
                        ? 'خطا در بارگذاری صفحه لایسنس. فایل لایسنس یافت نشد.'
                        : 'Error loading license page. License file not found.';
                    echo '</p></div>';
                }
                ?>
            </div>
        </div>
    </div>
    <?php
}
