<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

add_action( 'add_meta_boxes', 'wast_register_product_meta_boxes' );
add_action( 'save_post', 'wast_save_product_meta_box' );
add_filter( 'manage_edit-product_columns', 'wast_product_extra_columns' );
add_action( 'manage_product_posts_custom_column', 'wast_product_columns_content', 10, 2 );

/**
 * Register a new meta box
 */
function wast_register_product_meta_boxes() {
	add_meta_box(
		'wast-ticket-exp',
		'مدت زمات پشتیبانی (تیکت)',
		'wast_product_mtb_display_callback',
		'product',
		'side',
		'low'
	);
}

/**
 * Display CMB
 */
function wast_product_mtb_display_callback( $post ) {
	$product_exp_time = get_post_meta( $post->ID, '_wast_product_exp_time', true );
	?>
    <input type="number" class="small-text" name="product-exp-time" min="0" step="1" value="<?php echo $product_exp_time ? intval( $product_exp_time ) : '' ?>">
    <span> روز</span>
    <p class="description">
        <small>در صورت پشتیبانی نامحدود این فیلد را خالی رها کنید.</small>
    </p>
	<?php
	wp_nonce_field( 'ticket_exp_security', 'ticket_exp_nonce' );
}

/**
 * Save meta values in DB
 *
 * @param $post_id
 */
function wast_save_product_meta_box( $post_id ) {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	if ( ! isset( $_POST['ticket_exp_nonce'] ) || ! wp_verify_nonce( $_POST['ticket_exp_nonce'], 'ticket_exp_security' ) ) {
		return;
	}
	if ( ! current_user_can( 'edit_post' ) ) {
		return;
	}

	if ( isset( $_POST['product-exp-time'] ) && ! empty( $_POST['product-exp-time'] ) ) {
		update_post_meta( $post_id, '_wast_product_exp_time', intval( $_POST['product-exp-time'] ) );
	} else {
		delete_post_meta( $post_id, '_wast_product_exp_time' );
	}
}

/**
 * Add extra columns in admin post table
 *
 * @param $columns
 *
 * @return mixed
 */
function wast_product_extra_columns( $columns ) {
	$columns['wast_product_exp_time'] = 'پشتیبانی';

	return $columns;
}

/**
 * Show column content in admin post table
 *
 * @param $column_name
 * @param $post_id
 */
function wast_product_columns_content( $column_name, $post_id ) {
	$product_exp_time = get_post_meta( $post_id, '_wast_product_exp_time', true );

	switch ( $column_name ) {
		case 'wast_product_exp_time':
			echo $product_exp_time ? $product_exp_time . ' روز' : '–';
			break;
	}
}