<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );
?>
<?php WAST_Flash_Message::show_message(); ?>
    <form method="post">
        <table class="form-table">
            <tbody>
            <tr>
                <th scope="row">
                    <span>حذف فایل‌ها ضمیمه در صورتی که تاریخ آخرین پاسخ آنها از </span>
                    <input type="number" class="small-text" name="remove-files-period" dir="ltr" value="<?php echo esc_attr( wast_get_option( 'remove-files-period' ) ); ?>">
                    <span> ماه بیشتر باشد.</span>
                </th>
            </tr>
            </tbody>
        </table>
		<?php
		wp_nonce_field( 'wast_save_files', 'wast_files_nonce' );

		submit_button( 'ذخیره تغییرات', 'primary', 'wast-save-files-options', true );
		?>
    </form>
    <hr>
<?php
$remove_files = new WAST_Remove_Files();
$all_files    = $remove_files->get_all_files();

if ( count( $all_files ) ) {
	$i = 0;
	echo '<div class="wast-notice update-message notice inline notice-warning notice-alt" style="border: 1px solid #ffb900; border-right-width: 4px;">';
	echo '<p>پیشنهاد میشود قبل از حذف فایل ها حتما از پوشه uploads یک نسخه پشتیبان تهیه نمایید. فایل های حذف شده قابل بازگردانی نیستند.</p>';
	echo ' </div>';
	echo '<div class="wast-files-wrapper">';
	foreach ( $all_files as $file ) {
		$i ++;
		echo '<p>' . $i . ' - ' . $file . '</p>';
	}
	echo '</div>';
	echo '<form method="post">';
	wp_nonce_field( 'wast_remove_files', 'wast_remove_files_nonce' );
	submit_button( 'حذف فایل‌ها', 'primary', 'wast-remove-files-options', true );
	echo '</form>';
} else {
	echo '<p>موردی یافت نشد!</p>';
}