<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );
?>
<?php WAST_Flash_Message::show_message(); ?>
<form method="post">
    <table class="form-table">
        <tbody>
        <tr>
            <th scope="row">ایمیل اطلاع رسانی</th>
            <td>
                <label for="active-notifications">
                    <input name="active-notifications" type="checkbox" id="active-notifications" value="1"
						<?php checked( wast_get_option( 'active-notifications' ), 1 ); ?>>
                    <span>با فعال بودن این گزینه بعد از ارسال تیکت برای گیرنده تیکت ایمیل ارسال میشود.</span>
                </label>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="email-subject">عنوان ایمیل</label>
            </th>
            <td>
                <input type="text" name="email-subject" id="email-subject" class="regular-text"
                       value="<?php echo esc_attr( wast_get_option( 'email-subject' ) ); ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="email-sender">فرستنده</label>
            </th>
            <td>
                <input type="email" name="email-sender" id="email-sender" class="regular-text" dir="ltr"
                       value="<?php echo esc_attr( wast_get_option( 'email-sender' ) ); ?>">
            </td>
        </tr>
        <tr>
			<?php $logo = wast_get_option( 'site-logo' ) ? wast_get_option( 'site-logo' ) : ''; ?>
            <th scope="row">تصویر لوگو</th>
            <td>
                <img src="<?php echo esc_attr( $logo ); ?>" id="site-logo" alt="">
                <input type="hidden" id="site-logo_input" name="site-logo" value="<?php echo esc_attr( $logo ); ?>">
                <p style="margin-top: 5px;">
                    <a href="#" class="button select-uploader" data-target="site-logo" data-target-type="image">انتخاب تصویر</a>
                    <a href="#" class="button remove-uploader" data-target="site-logo">حذف تصویر</a>
                </p>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="email-footer-text">متن پابرگ</label>
            </th>
            <td>
                <textarea name="email-footer-text" id="email-footer-text" class="large-text" rows="4"><?php echo esc_textarea( wast_get_option( 'email-footer-text' ) ); ?></textarea>
            </td>
        </tr>
        <tr>
            <td colspan="2">
                <hr>
            </td>
        </tr>
        <tr>
            <th scope="row">پیامک اطلاع رسانی</th>
            <td>
                <label for="active-sms-notifications">
                    <input name="active-sms-notifications" type="checkbox" id="active-sms-notifications" value="1"
						<?php checked( wast_get_option( 'active-sms-notifications' ), 1 ); ?>>
                    <span>با فعال بودن این گزینه بعد از ارسال تیکت برای گیرنده تیکت پیامک ارسال میشود.</span>
                </label>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="sms-service">سرویس دهنده پیامک</label>
            </th>
            <td>
                <select name="sms-service" id="sms-service">
                    <option>لطفا انتخاب کنید.</option>
                    <option value="melipayamak" <?php selected( wast_get_option( 'sms-service' ), 'melipayamak' ); ?>>melipayamak.ir</option>
                    <option value="newsms" <?php selected( wast_get_option( 'sms-service' ), 'newsms' ); ?>>newsms.ir</option>
                    <option value="smsir" <?php selected( wast_get_option( 'sms-service' ), 'smsir' ); ?>>sms.ir</option>
                    <option value="payamresan" <?php selected( wast_get_option( 'sms-service' ), 'payamresan' ); ?>>payam-resan.com</option>
                    <option value="farapayamak" <?php selected( wast_get_option( 'sms-service' ), 'farapayamak' ); ?>>farapayamak.ir</option>
                    <option value="payamkutah" <?php selected( wast_get_option( 'sms-service' ), 'payamkutah' ); ?>>payamkutah.com</option>
                    <option value="zhiak" <?php selected( wast_get_option( 'sms-service' ), 'zhiak' ); ?>>sms.zhiak.com</option>
                    <option value="maxsms" <?php selected( wast_get_option( 'sms-service' ), 'maxsms' ); ?>>max-sms.ir</option>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="sms-username">نام کاربری پنل پیامک</label>
            </th>
            <td>
                <input type="text" name="sms-username" id="sms-username" class="regular-text" dir="ltr" value="<?php echo esc_attr( wast_get_option( 'sms-username' ) ); ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="sms-pass">رمزعبور پنل پیامک</label>
            </th>
            <td>
                <input type="text" name="sms-pass" id="sms-pass" class="regular-text" dir="ltr" value="<?php echo esc_attr( wast_get_option( 'sms-pass' ) ); ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="sms-sender">شماره خط اختصاصی</label>
            </th>
            <td>
                <input type="text" name="sms-sender" id="sms-sender" class="regular-text" dir="ltr" value="<?php echo esc_attr( wast_get_option( 'sms-sender' ) ); ?>">
            </td>
        </tr>
        </tbody>
    </table>
	<?php
	wp_nonce_field( 'wast_save_notifications', 'wast_notifications_nonce' );

	submit_button( 'ذخیره تغییرات', 'primary', 'wast-save-notifications-options', true );
	?>
</form>
