<?php
namespace Elementor;

class search1 extends Widget_Base {
	
	public function get_name() {
		return 'search1';
	}
	
	public function get_title() {
		return 'جستجو 1';
	}
	
	    public function get_icon() {
		return 'eicon eicon-search';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }
	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);

		$this->end_controls_section();
		
		
		
		       $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );

		
		       $this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش فیلد دسته بندی', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش دکمه دسته بندی', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
        $this->end_controls_section();


        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             


$this->add_control(
'color_farnam_1',
			[
				'label' => __( 'رنگ پس زمینه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sssbox.newsearch.yad-2020-1' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   
$this->add_control(
'color_farnam_2',
			[
				'label' => __( 'رنگ دکمه جستجو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .sssbox.newsearch.yad-2020-1 .submit.icon-search' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
$this->add_control(
'color_farnam_3',
			[
				'label' => __( 'رنگ ایکون جستجو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .sssbox.newsearch.yad-2020-1 .submit.icon-search' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'color_farnam_4',
			[
				'label' => __( 'رنگ متن فیلد جستجو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sssbox.newsearch.yad-2020-1 .search-field' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   	   $this->add_control(
'color_farnam_5',
			[
				'label' => __( 'رنگ متن فیلد دسته بندی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sssbox.newsearch.yad-2020-1 #product_cat' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی دور جستجو', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .sssbox.newsearch.yad-2020-1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

  $this->add_responsive_control(
                        'farnamborder2',
                        [
                            'label' => esc_html__( 'گردی دکمه جستجو', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .sssbox.newsearch.yad-2020-1 .submit.icon-search' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
			        $this->end_controls_section();

					
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		


		?>
      <div class="sssbox newsearch yad-2020-1"><form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	
	<input type="search" id="<?php echo $unique_id; ?>" class="search-field" placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'twentyseventeen' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
 <?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>
<div class="riazi45"><?php wc_product_dropdown_categories(); ?></div><?php }
						
					?>
					 <?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>

 <button type="submit" class="submit icon-search"><i class="fa fa-search"></i></button><?php }
						
					?>
<input type="hidden" name="post_type" value="product" /></form>
</div>
		<?php


	}


	
	protected function _content_template() {

    }
	
	
}