<?php
$posts_args = array(
	'post_type'      => 'post',
	'posts_per_page' => $posts_per_page,
);

if ( $orderby_visit ) {
	$posts_args['orderby']  = 'meta_value_num';
	$posts_args['meta_key'] = '_es_post_views_count';
}

$posts = new WP_Query( $posts_args );

if ( $posts->have_posts() ) {
	echo '<ul class="list-group">';
	while ( $posts->have_posts() ) {
		$posts->the_post();
		?>
		<li class="list-group-item">
			<a href="<?php echo get_the_permalink( $posts->post->ID ); ?>" title="<?php echo get_the_title( $posts->post->ID ); ?>">
				<?php the_post_thumbnail('thumbnail'); ?>

			<div class="mmm-ddf">
				<h5 class="post-title"><?php echo get_the_title( $posts->post->ID ); ?></h5>
				<?php if ( $show_date ): ?>
					<time class="post-date"><?php echo get_the_date( 'Y-m-d', $posts->post->ID ); ?></time>
				<?php endif; ?>
				</div>
			</a>
		</li>
		<?php
	}
	echo '</ul>';
	echo '';
	wp_reset_postdata();
}
