<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

/**
 * Add submenu
 */
add_action( 'admin_menu', 'wast_plugin_menu' );
function wast_plugin_menu() {
	add_submenu_page(
		'edit.php?post_type=ticket',
		'تنظیمات',
		'تنظیمات',
		'manage_options',
		'wast-options',
		'wast_options_menu_page'
	);
}

/**
 * Options submenu page content
 */
function wast_options_menu_page() {
	?>
    <div class="wrap">
        <h2>تنظیمات تیکت پشتیبانی</h2>
        <nav class="nav-tab-wrapper">
			<?php
			foreach ( wast_allowed_tab() as $tab_key => $tab_label ) {
				echo '<a href="' . esc_url( add_query_arg( array( 'tab' => $tab_key ) ) ) . '" class="nav-tab ' . wast_get_active_class( $tab_key ) . '">' . $tab_label . '</a>';
			}
			?>
        </nav>
		<?php wast_get_tab_content(); ?>
    </div>
	<?php
}

/**
 * Get tab whitelist
 * @return array
 */
function wast_allowed_tab() {
	return array(
		'general'       => 'همگانی',
		'woo'           => 'ووکامرس',
		'template'      => 'قالب',
		'upload-file'   => 'آپلود فایل',
		'notifications' => 'اعلانات',
		'files'         => 'فایل‌ها',
	);
}

/**
 * Get active tab template content
 */
function wast_get_tab_content() {
	$file = WAST_TPL_PATH . 'options/tpl-' . wast_get_active_tab() . '.php';
	if ( is_file( $file ) && file_exists( $file ) ) {
		$save_function = 'wast_save_' . str_replace( '-', '_', wast_get_active_tab() ) . '_options';
		if ( function_exists( $save_function ) ) {
			call_user_func( $save_function );
		}

		include $file;
	}
}

/**
 * Get active tab from query string
 * @return mixed
 */
function wast_get_active_tab() {
	$tab = array_keys( wast_allowed_tab() )[0];

	if ( isset( $_GET['tab'] ) && in_array( $_GET['tab'], array_keys( wast_allowed_tab() ) ) ) {
		$tab = $_GET['tab'];
	}

	return $tab;
}

/**
 * Get active class
 *
 * @param $tab
 *
 * @return null|string
 */
function wast_get_active_class( $tab ) {
	return wast_get_active_tab() == $tab ? 'nav-tab-active' : null;
}

/**
 * Save general tab options
 */
function wast_save_general_options() {
	if ( isset( $_POST['wast-save-general-options'] ) ) {
		if ( ! isset( $_POST['wast_general_nonce'] ) || ! wp_verify_nonce( $_POST['wast_general_nonce'], 'wast_save_general' ) ) {
			exit( 'Sorry, your nonce did not verify!' );
		} else {
			wast_update_option( 'ticket-page', false );
			wast_update_option( 'help-info', false );
			wast_update_option( 'limit-access', false );
			wast_update_option( 'wp-editor', false );
			wast_update_option( 'posts-per-page', false );
			wast_update_option( 'orderby', false );
			wast_update_option( 'show-icon', false );
			wast_update_option( 'support-icon' );
			wast_update_option( 'support-icon-alignment' );
			wast_update_option( 'ticket-order', false );
			wast_update_option( 'auto-close-period', false );
			wast_update_option( 'custom-css' );

			WAST_Flash_Message::add_message( 'تنظیمات با موفقیت ذخیره شد.' );
		}
	}
}

/**
 * Save woo tab options
 */
function wast_save_woo_options() {
	if ( isset( $_POST['wast-save-woo-options'] ) ) {
		if ( ! isset( $_POST['wast_woo_nonce'] ) || ! wp_verify_nonce( $_POST['wast_woo_nonce'], 'wast_save_woo' ) ) {
			exit( 'Sorry, your nonce did not verify!' );
		} else {
			wast_update_option( 'wc-support', false );
			wast_update_option( 'expiration-time', false );
			wast_update_option( 'seller-support', false );
			wast_update_option( 'dokan-ticket-type', false );

			WAST_Flash_Message::add_message( 'تنظیمات با موفقیت ذخیره شد.' );
		}
	}
}

/**
 * Save template tab options
 */
function wast_save_template_options() {
	if ( isset( $_POST['wast-save-template-options'] ) ) {
		if ( ! isset( $_POST['wast_template_nonce'] ) || ! wp_verify_nonce( $_POST['wast_template_nonce'], 'wast_save_template' ) ) {
			exit( 'Sorry, your nonce did not verify!' );
		} else {
			wast_update_option( 'header-text' );
			wast_update_option( 'footer-text' );

			WAST_Flash_Message::add_message( 'تنظیمات با موفقیت ذخیره شد.' );
		}
	}
}

/**
 * Save upload-file options
 */
function wast_save_upload_file_options() {
	if ( isset( $_POST['wast-save-upload-options'] ) ) {
		if ( ! isset( $_POST['wast_upload_nonce'] ) || ! wp_verify_nonce( $_POST['wast_upload_nonce'], 'wast_save_upload' ) ) {
			exit( 'Sorry, your nonce did not verify!' );
		} else {
			wast_update_option( 'active-upload', false );
			wast_update_option( 'file-max-size' );
			wast_update_option( 'file-ext' );

			WAST_Flash_Message::add_message( 'تنظیمات با موفقیت ذخیره شد.' );
		}
	}
}

/**
 * Save notifications options
 */
function wast_save_notifications_options() {
	if ( isset( $_POST['wast-save-notifications-options'] ) ) {
		if ( ! isset( $_POST['wast_notifications_nonce'] ) || ! wp_verify_nonce( $_POST['wast_notifications_nonce'], 'wast_save_notifications' ) ) {
			exit( 'Sorry, your nonce did not verify!' );
		} else {
			wast_update_option( 'active-notifications', false );
			wast_update_option( 'email-subject' );
			wast_update_option( 'email-sender' );
			wast_update_option( 'site-logo' );
			wast_update_option( 'email-footer-text' );

			wast_update_option( 'active-sms-notifications', false );
			wast_update_option( 'sms-service' );
			wast_update_option( 'sms-username' );
			wast_update_option( 'sms-pass' );
			wast_update_option( 'sms-sender' );

			WAST_Flash_Message::add_message( 'تنظیمات با موفقیت ذخیره شد.' );
		}
	}
}

/**
 * Save files options
 */
function wast_save_files_options() {
	if ( isset( $_POST['wast-save-files-options'] ) ) {
		if ( ! isset( $_POST['wast_files_nonce'] ) || ! wp_verify_nonce( $_POST['wast_files_nonce'], 'wast_save_files' ) ) {
			exit( 'Sorry, your nonce did not verify!' );
		} else {
			wast_update_option( 'remove-files-period', false );

			WAST_Flash_Message::add_message( 'تنظیمات با موفقیت ذخیره شد.' );
		}
	}

	if ( isset( $_POST['wast-remove-files-options'] ) ) {
		if ( ! isset( $_POST['wast_remove_files_nonce'] ) || ! wp_verify_nonce( $_POST['wast_remove_files_nonce'], 'wast_remove_files' ) ) {
			exit( 'Sorry, your nonce did not verify!' );
		} else {
			$remove_files = new WAST_Remove_Files();
			$remove_files->remove_files();
			$remove_files->delete_meta();

			WAST_Flash_Message::add_message( 'فایل‌ها با موفقیت حذف گردیدند.' );
		}
	}
}