<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

add_action( 'init', 'wast_register_ticket_cpt' );
add_action( 'init', 'wast_ticket_post_statuses' );
add_action( 'add_meta_boxes', 'wast_register_ticket_meta_boxes' );
add_action( 'save_post', 'wast_ticket_save_meta_box' );
add_filter( 'manage_edit-ticket_columns', 'wast_ticket_extra_columns' );
add_action( 'manage_ticket_posts_custom_column', 'wast_ticket_columns_content', 10, 2 );
add_filter( 'manage_edit-ticket_sortable_columns', 'wast_ticket_sortable_column' );
add_action( 'pre_get_posts', 'wast_ticket_column_orderby' );
add_filter( 'bulk_actions-edit-ticket', 'wast_register_ticket_bulk_actions' );
add_filter( 'handle_bulk_actions-edit-ticket', 'wast_ticket_bulk_action_handler', 10, 3 );
add_action( 'admin_init', 'wast_ticket_bulk_action_admin_notice' );

/**
 * Register ticket CPT
 */
function wast_register_ticket_cpt() {
	$labels = array(
		'name'               => 'تیکت',
		'singular_name'      => 'تیکت',
		'menu_name'          => 'تیکت‌ها',
		'name_admin_bar'     => 'تیکت',
		'add_new'            => 'تیکت جدید',
		'add_new_item'       => 'اضافه کردن تیکت جدید',
		'new_item'           => 'تیکت جدید',
		'edit_item'          => 'ویرایش تیکت',
		'view_item'          => 'نمایش تیکت',
		'all_items'          => 'همه تیکت‌ها',
		'search_items'       => 'جستجوی تیکت‌ها',
		'parent_item_colon'  => 'والد تیکت‌ها',
		'not_found'          => 'تیکتی یافت نشد!',
		'not_found_in_trash' => 'تیکتی در زباله دان یافت نشد!',
	);
	$args   = array(
		'labels'              => $labels,
		'description'         => 'تیکت‌ها',
		'public'              => true,
		'publicly_queryable'  => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'query_var'           => true,
		'rewrite'             => array( 'slug' => 'ticket' ),
		'capability_type'     => 'post',
		'capabilities'        => array(
			'create_posts' => 'do_not_allow',
		),
		'map_meta_cap'        => true,
		'has_archive'         => true,
		'hierarchical'        => true,
		'menu_position'       => 25,
		'supports'            => array( 'title', 'editor' ),
		'menu_icon'           => 'dashicons-sos',
		'taxonomies'          => array( 'ticket-type' ),
		'exclude_from_search' => true,
	);
	register_post_type( 'ticket', $args );
}

/**
 * Retrieve all ticket status
 * @return array
 */
function wast_get_ticket_statuses() {
	return array(
		'open'        => 'نیاز به پاسخ',
		'in_progress' =>  'در حال بررسی',
		'closed'      => 'بسته شده',
		'answered'    => 'پاسخ داده‌شده',
	);
}

/**
 * Register ticket statuses
 */
function wast_ticket_post_statuses() {
	$statuses = wast_get_ticket_statuses();

	foreach ( $statuses as $key => $value ) {
		register_post_status(
			$key,
			array(
				'label'                     => $value,
				'public'                    => true,
				'exclude_from_search'       => false,
				'show_in_admin_all_list'    => true,
				'show_in_admin_status_list' => true,
				'label_count'               => _n_noop( ' <span class="count">(%s)</span>' . $value, ' <span class="count">(%s)</span>' . $value ),
			)
		);
	}
}

/**
 * Register a new meta box
 */
function wast_register_ticket_meta_boxes() {
	add_meta_box(
		'ticket-info',
		'اطلاعات تیکت',
		'wast_ticket_mtb_display_callback',
		'ticket'
	);

	add_meta_box(
		'ticket-reply',
		'درج پاسخ',
		'wast_ticket_reply_mtb_display_callback',
		'ticket'
	);

	add_meta_box(
		'ticket-replies',
		'پاسخ‌های تیکت',
		'wast_ticket_replies_mtb_display_callback',
		'ticket'
	);
}

/**
 * Display ticket CMB
 */
function wast_ticket_mtb_display_callback( $post ) {
	$post_author_id = get_post_field( 'post_author', $post->ID );
	$user_info      = get_userdata( $post_author_id );
	$status         = get_post_status( $post->ID );
	$priority       = get_post_meta( $post->ID, '_wast_ticket_priority', true );
	$product_id     = get_post_meta( $post->ID, '_wast_ticket_product_id', true );
	$ath_file       = get_post_meta( $post->ID, '_wast_ticket_ath_file', true );
	?>
    <table>
        <tbody>
        <tr>
            <td>کاربر:</td>
            <td>
				<?php echo '<a href="' . get_edit_user_link( $post_author_id ) . '" target="_blank">' . $user_info->user_login . '</a>'; ?>
            </td>
        </tr>
        <tr>
            <td>
                <label for="status">وضعیت:</label>
            </td>
            <td>
                <select name="status" id="status">
					<?php
					foreach ( wast_get_ticket_statuses() as $key => $value ) {
						echo '<option value="' . $key . '" ' . selected( $key, $status ) . '>' . $value . '</option>';
					}
					?>
                </select>
            </td>
        </tr>
        <tr>
            <td>
                <label for="priority">اولویت:</label>
            </td>
            <td>
                <select name="priority" id="priority">
                    <option value="low" <?php selected( $priority, 'low' ); ?>>کم</option>
                    <option value="medium" <?php selected( $priority, 'medium' ); ?>>متوسط</option>
                    <option value="high" <?php selected( $priority, 'high' ); ?>>بالا</option>
                </select>
            </td>
        </tr>
        <tr>
            <td>
                <label for="product-id">محصول:</label>
            </td>
            <td>

				<?php
				echo '<input type="text" class="regular-text" name="product-id" id="product-id" value="' . esc_attr( $product_id ) . '"><br>';
				if ( ctype_digit( $product_id ) ) {
					echo '<a href="' . get_edit_post_link( $product_id ) . '" target="_blank">' . get_the_title( $product_id ) . '</a>';
				}
				?>
            </td>
        </tr>
        <tr>
            <td>
                <label for="ath-file">فایل ضمیمه:</label>
            </td>
            <td>
                <input type="text" class="regular-text" name="ath-file" id="ath-file" value="<?php echo esc_attr( $ath_file ); ?>" dir="ltr">
                <a href="<?php echo esc_url( $ath_file ); ?>" class="button" target="_blank">دانلود فایل ضمیمه</a>
            </td>
        </tr>
        

        </tbody>
    </table>
	<?php
	wp_nonce_field( 'ticket_info_security', 'ticket_info_nonce' );
}

/**
 * Display ticket reply CMB
 *
 * @param $post
 */
function wast_ticket_reply_mtb_display_callback( $post ) {
	echo '<a href="#" id="wast-pre-answer" class="button button-primary">درج پیش پاسخ</a>';
	echo '<div class="wast-pre-answer-wrapper">';
	$pa_posts_args = array(
		'post_type'      => 'pre-answer',
		'posts_per_page' => - 1,
		'author'         => get_current_user_id(),
	);

	$pa_posts = get_posts( $pa_posts_args );
	if ( sizeof( $pa_posts ) ) {
		echo '<ul>';
		foreach ( $pa_posts as $post ) {
			setup_postdata( $post );
			echo '<li>';
			echo '<strong class="title">' . get_the_title( $post->ID ) . '<a href="#" class="dashicons dashicons-arrow-down-alt2"></a><a href="#" class="dashicons dashicons-editor-textcolor" data-editor-id="r-ticket-content"></a></strong>';
			echo '<div class="content">' . apply_filters( 'the_content', get_the_content( $post->ID ) ) . '</div>';
			echo '</li>';
		}
		echo '</ul>';
		wp_reset_postdata();
	}
	echo '</div>';

	wp_editor( '', 'r-ticket-content', array( 'textarea_rows' => 10 ) );

	echo '<p style="margin-top: 10px;">فایل ضمیمه: ';
	echo '<input type="text" id="r-reply-ath-file_input" class="regular-text" name="r-reply-ath-file" value="" dir="ltr">';
	echo '<a href="#" class="select-uploader button" data-target="r-reply-ath-file" data-target-type="image">انتخاب تصویر</a>';
	echo '</p>';
	echo '<div class="wast-notice update-message notice inline notice-warning notice-alt"><p>';
	echo 'جهت عدم بروز مشکل در حذف فایل های قدیمی پیشنهاد میشود چنانچه فایلی را در جایی دیگر بارگذاری کرده اید را انتخاب ننمایید.';
	echo '</p></div>';
}

/**
 * Display ticket replies CMB
 */
function wast_ticket_replies_mtb_display_callback( $post ) {
	$replies = wast_get_ticket_replies( $post->ID );

	// Sort replies by date
	wast_aasort( $replies, "date" );

	if ( wast_get_option( 'ticket-order' ) == 'desc' ) {
		$replies = array_reverse( $replies );
	}

	if ( sizeof( $replies ) ) {
		$i = 0;
		foreach ( $replies as $reply ) {
			if ( ! is_array( $reply ) ) {
				continue;
			}
			if ( array_key_exists( 'content', $reply ) && array_key_exists( 'ath_file', $reply ) ) {
				if ( ! $reply['content'] && ! $reply['ath_file'] ) {
					continue;
				}
			}
			if ( ! array_key_exists( 'content', $reply ) && ! array_key_exists( 'ath_file', $reply ) ) {
				continue;
			}
			?>
            <div style="margin-bottom: 20px;">
				<?php
				$date      = $reply['date'];
				$author_id = $reply['author_id'];
				$user_info = get_userdata( $author_id );
				echo '<strong><a href="' . get_edit_user_link( $author_id ) . '" target="_blank">' . $user_info->display_name . '</a></strong>';
				?>
                <time dir="ltr" style="color: #a0a0a0; margin-right: 7px;"><?php echo date_i18n( 'Y/m/d - H:i', $reply['date'] ); ?></time>
            </div>
            <div>
                <input type="hidden" name="author-id[]" value="<?php echo esc_attr( $author_id ); ?>">
                <input type="hidden" name="date[]" value="<?php echo esc_attr( $date ); ?>">
				<?php
				wp_editor( $reply['content'], 'ticket-content' . ( $i + 1 ), array( 'textarea_name' => 'ticket-content[]',
				                                                                    'textarea_rows' => 10 ) );

				$ath_file = array_key_exists( 'ath_file', $reply ) ? $reply['ath_file'] : '';
				echo '<p style="margin-top: 10px;">فایل ضمیمه: ';
				echo '<input type="text" class="regular-text" name="reply-ath-file[]" value="' . esc_attr( $ath_file ) . '" dir="ltr">';
				if ( $ath_file ) {
					echo '<a href="' . esc_attr( $ath_file ) . '" class="button" target="_blank">دانلود فایل ضمیمه</a>';
				}
				echo '</p>';
				?>
            </div>
			<?php
			$i ++;
			if ( sizeof( $replies ) != $i ) {
				echo '<hr style="margin: 25px 0; border-top: 3px solid #2980b9; border-bottom: none;">';
			}
		}
	}
}

/**
 * Save ticket meta values in DB
 *
 * @param $post_id
 */
function wast_ticket_save_meta_box( $post_id ) {

	if ( isset( $_POST['status'] ) && ! empty( $_POST['status'] ) ) {
		wast_set_post_status( $_POST['status'], $post_id );
	}

	if ( isset( $_POST['priority'] ) && ! empty( $_POST['priority'] ) ) {
		update_post_meta( $post_id, '_wast_ticket_priority', $_POST['priority'] );
	}

	if ( isset( $_POST['product-id'] ) && ! empty( $_POST['product-id'] ) ) {
		update_post_meta( $post_id, '_wast_ticket_product_id', sanitize_text_field( $_POST['product-id'] ) );
	} else {
		delete_post_meta( $post_id, '_wast_ticket_product_id' );
	}

	if ( isset( $_POST['ath-file'] ) && ! empty( $_POST['ath-file'] ) ) {
		update_post_meta( $post_id, '_wast_ticket_ath_file', $_POST['ath-file'] );
	} else {
		/*$file = get_post_meta( $post_id, '_wast_ticket_ath_file', true );
		delete_post_meta( $post_id, '_wast_ticket_ath_file' );

		$path = parse_url( $file, PHP_URL_PATH );

		$file_path = $_SERVER['DOCUMENT_ROOT'] . $path;

		@unlink( $file_path );*/
	}

	$reply_count = wast_get_reply_count( $post_id );

	$i = 0;

// بررسی اگر $_POST['ticket-content'] یک آرایه معتبر باشد
if (isset($_POST['ticket-content']) && is_array($_POST['ticket-content'])) {
    foreach ($_POST['ticket-content'] as $content) {
        // اطمینان از وجود دیگر فیلدها
        if (isset($_POST['author-id'][$i], $_POST['date'][$i], $_POST['reply-ath-file'][$i])) {
            $reply['author_id'] = sanitize_text_field($_POST['author-id'][$i]);
            $reply['date'] = sanitize_text_field($_POST['date'][$i]);
            $reply['content'] = $content;
            $reply['ath_file'] = sanitize_text_field($_POST['reply-ath-file'][$i]);
            update_post_meta($post_id, '_wast_ticket_reply' . ($i + 1), $reply);
            $i++;
        } else {
            // اگر یک یا چند فیلد مورد نیاز وجود نداشته باشد، می‌توانید اقدامات لازم را انجام دهید
            // مثلاً یک پیام خطا نمایش دهید یا فرآیند را متوقف کنید
        }
    }
} else {
    // اگر $_POST['ticket-content'] یک آرایه معتبر نباشد، اقدامات لازم را انجام دهید
    // مثلاً یک پیام خطا نمایش دهید یا فرآیند را متوقف کنید
}

	if ( isset( $_POST['r-ticket-content'] ) && ! empty( $_POST['r-ticket-content'] ) ) {
		$_reply            = array(
			'author_id' => get_current_user_id(),
			'date'      => time(),
		);
		$_reply['content'] = stripslashes( $_POST['r-ticket-content'] );
		if ( isset( $_POST['r-reply-ath-file'] ) && ! empty( $_POST['r-reply-ath-file'] ) ) {
			$_reply['ath_file'] = $_POST['r-reply-ath-file'];
		}

		update_post_meta( $post_id, '_wast_ticket_reply' . ( $reply_count + 1 ), $_reply );
		update_post_meta( $post_id, '_wast_ticket_last_reply_date', time() );

		// send notification to user
		$post_author_id = get_post_field( 'post_author', $post_id );
		$user_info      = get_userdata( $post_author_id );
		$to             = $user_info->user_email;

		$recipient        = get_user_by( 'email', $to );
		$recipient_mobile = get_user_meta( $recipient->ID, '_wast_mobile', true );

		do_action( 'wast_send_email', $to, $post_id );
		do_action( 'wast_send_sms', $recipient_mobile, $post_id );
	}
}

/**
 * Add extra columns in admin post table
 *
 * @param $columns
 *
 * @return mixed
 */
function wast_ticket_extra_columns( $columns ) {
	$columns['wast_ticket_user']     = 'کاربر';
	$columns['wast_ticket_status']   = 'وضعیت';
	$columns['wast_product']         = 'محصول';
	$columns['wast_last_reply']      = 'آخرین پاسخ';
	$columns['wast_ticket_priority'] = 'اولویت';

	return $columns;
}

/**
 * Show column content in admin post table
 *
 * @param $column_name
 * @param $post_id
 */
function wast_ticket_columns_content( $column_name, $post_id ) {
	$post_author_id = get_post_field( 'post_author', $post_id );
	$user_info      = get_userdata( $post_author_id );
	$status         = get_post_status( $post_id );
	$product_id     = get_post_meta( $post_id, '_wast_ticket_product_id', true );
	$last_reply     = get_post_meta( $post_id, '_wast_ticket_last_reply_date', true );
	$priority       = get_post_meta( $post_id, '_wast_ticket_priority', true );

	switch ( $column_name ) {
		case 'wast_ticket_user':
			echo '<a href="' . get_edit_user_link( $post_author_id ) . '" target="_blank">' . $user_info->display_name . '</a>';
			echo '<p><a class="wast-filter-author" href="' . add_query_arg( array( '_author_id' => $post_author_id ) ) . '">نمایش تیکت‌های کاربر</a></p>';
			break;
		case 'wast_ticket_status':
			foreach ( wast_get_ticket_statuses() as $key => $value ) {
				if ( $status == $key ) {
					echo '<span class="status status-' . $key . '">' . $value . '</span>';
					break;
				}
			}
			break;
		case 'wast_product':
			if ( is_numeric( $product_id ) ) {
				echo '<a href="' . get_edit_post_link( $product_id ) . '" target="_blank">' . get_the_title( $product_id ) . '</a>';
			} else {
				echo $product_id;
			}
			break;
		case 'wast_last_reply':
			echo wast_time_ago( $last_reply );
			echo ' <span class="wast-reply-count">(' . wast_get_reply_count( $post_id ) . ')</span>';
			break;
		case 'wast_ticket_priority':
			switch ( $priority ) {
				case 'low':
					echo '<span class="badge gray">کم</span>';
					break;
				default:
				case 'medium':
					echo '<span class="badge blue">متوسط</span>';
					break;
				case 'high':
					echo '<span class="badge red">زیاد</span>';
					break;
			}
			break;
	}
}

/**
 * Make column sortable
 * @return mixed
 */
function wast_ticket_sortable_column() {
	$columns['wast_last_reply'] = 'wast_last_reply';

	return $columns;
}

/**
 * Sortable column orderby query
 *
 * @param $query
 */
function wast_ticket_column_orderby( $query ) {
	if ( ! is_admin() ) {
		return;
	}
	$orderby = $query->get( 'orderby' );
	if ( $orderby == 'wast_last_reply' ) {
		$query->set( 'meta_key', '_wast_ticket_last_reply_date' );
		$query->set( 'orderby', 'meta_value_num' );
	}
}

/**
 * Register bulk actions
 *
 * @param $bulk_actions
 *
 * @return mixed
 */
function wast_register_ticket_bulk_actions( $bulk_actions ) {
	foreach ( wast_get_ticket_statuses() as $key => $value ) {
		$bulk_actions[ 'to_' . $key ] = 'تغییر به ' . $value;
	}

	return $bulk_actions;
}

/**
 * Perform bulk action
 *
 * @param $redirect_to
 * @param $action_name
 * @param $post_ids
 *
 * @return string
 */
function wast_ticket_bulk_action_handler( $redirect_to, $action_name, $post_ids ) {
	global $wpdb;

	foreach ( wast_get_ticket_statuses() as $key => $value ) {
		if ( $action_name === 'to_' . $key ) {
			foreach ( $post_ids as $post_id ) {
				$wpdb->query(
					$wpdb->prepare( "UPDATE `$wpdb->posts` SET `post_status` = %s WHERE `ID` = %d", $key, $post_id )
				);
			}
			$redirect_to = add_query_arg( 'ticket_bulk_processed', count( $post_ids ), $redirect_to );

			return $redirect_to;
		}
	}
}

/**
 * Show admin notice after bulk action
 */
function wast_ticket_bulk_action_admin_notice() {
	if ( ! empty( $_REQUEST['ticket_bulk_processed'] ) ) {
		$posts_count = intval( $_REQUEST['ticket_bulk_processed'] );
		?>
        <div class="notice notice-success is-dismissible">
            <p><strong><?php echo $posts_count; ?></strong> تیکت تغییر وضعیت داده شد.</p>
        </div>
		<?php
	}
}