<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class product113 extends Widget_Base {

    public function get_name() {
        return 'product113';
    }
    
    public function get_title() {
        return __( 'اسلایدر محصولات 12', 'woolentor' );
    }

    public function get_icon() {
		return 'eicon eicon-bag-medium';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }

    public function get_script_depends() {
        return [
            'woolentor-widgets-scripts',
            'slick',
        ];
    }

    protected function register_controls() {


        $this->start_controls_section(
            'woolentor-products',
            [
                'label' => esc_html__( 'تنظیمات محصول', 'woolentor' ),
            ]
        );
                

            $this->add_control(
                'woolentor_product_grid_product_filter',
                [
                    'label' => esc_html__( 'فيلتر شده', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'recent',
                    'options' => [
                        'recent' => esc_html__( 'آخرين محصولات', 'woolentor' ),
                        'featured' => esc_html__( 'محضولات ويژه', 'woolentor' ),
                        'best_selling' => esc_html__( 'محصولات پر فروش', 'woolentor' ),
                        'sale' => esc_html__( 'محصولات تخفيفي', 'woolentor' ),
                        'top_rated' => esc_html__( 'محصولات محبوب', 'woolentor' ),
                    ],
                ]
            );
           
            $this->add_control(
              'woolentor_product_grid_row',
              [
                 'label'   => __( 'ستون', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 1,
                 'min'     => 1,
                 'max'     => 1,
                 'step'    => 1,
              ]
            );

            $this->add_control(
              'woolentor_product_grid_products_count',
              [
                 'label'   => __( 'تعداد محصولات', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 4,
                 'min'     => 1,
                 'max'     => 100,
                 'step'    => 1,
              ]
            );

            $this->add_control(
                'woolentor_product_grid_categories',
                [
                    'label' => esc_html__( 'دسته بندي محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => woolentor_woocommerce_product_categories(),
                ]
            );
			            $this->add_control(
			'widget_title',
			[
				'label' => __( 'عنوان', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'اسلایدر اخرین گل و گیاه', 'plugin-domain' ),
				'placeholder' => __( 'متن خود را وارد کنید', 'plugin-domain' ),
			]
		);

			
			$this->add_control(
			'imageasl',
			[
				'label' => esc_html__( 'تصویر اصلی', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		
		
		$this->add_control(
			'icon',
			[
				'label' => __( 'ایکون', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
			
           				$this->add_control(
			'code_slider',
			[
				'label' => __( 'کد اسلایدر ', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'مثلا : d99 ', 'elementor' ),
			]
		);
		$this->add_control(
			'zaman',
			[
				'label' => __( 'زمان اتمام تخفیف  ( میلادی ) ', 'elementor' ),
				'label_block' => true,
				'type' => \Elementor\Controls_Manager::DATE_TIME,
			]
		);
		

                   $this->end_controls_section();

		       $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );
		$this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش شمارنده', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		
 
       $this->add_control(
			'farnamoneshow3',
			[
				'label' => __( 'نمایش تصویر اصلی', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
      $this->add_control(
			'farnamoneshow4',
			[
				'label' => __( 'نمایش تخفیف', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'farnamoneshow5',
			[
				'label' => __( 'نمایش قیمت', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->end_controls_section();


        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             
 

		   
		     $this->add_control(
                        'titr-12-3w',
                        [
                            'label' => __( 'رنگ باکس سمت راست', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
	
	$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background1',
				'label' => esc_html__( 'پس زمینه', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .rast-right-403-farvardin-two',
			]
		);
		   
		   $this->add_control(
'color_farnam_2',
			[
				'label' => __( 'رنگ پس زمینه المان svg', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .rast-right-403-farvardin-two svg path' => 'fill: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'color_farnam_3',
			[
				'label' => __( 'رنگ متن زمان باقی مانده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .iran-pak-offer-farvardin-403-one span' => 'color: {{VALUE}} !important',
				],
			]
           );

	
		   	 	   $this->add_control(
'color_farnam_6',
			[
				'label' => __( 'رنگ پس زمینه تایمر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .iran-pak-offer-farvardin-403-one .tarh-gaj-offer' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   
	
		   
		   	   	 	   $this->add_control(
'color_farnam_7',
			[
				'label' => __( 'رنگ متن تایمر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .iran-pak-offer-farvardin-403-one .tarh-gaj-offer' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		      	   	 	   $this->add_control(
'color_farnam_8',
			[
				'label' => __( 'رنگ ایکون تایمر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .iran-pak-offer-farvardin-403-one i' => 'color: {{VALUE}} !important',
				],
			]
           );  
		      $this->add_control(
'color_farnam_37',
			[
				'label' => __( 'رنگ پس زمینه ایکون عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .title-left-403-farvardin-one i' => 'background: {{VALUE}} !important',
				],
			]
           );  $this->add_control(
'color_farnam_327',
			[
				'label' => __( 'رنگ ایکون عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .title-left-403-farvardin-one i' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   		      	  
		   
		   		   
		   		      	   	 	   $this->add_control(
'color_farnam_10',
			[
				'label' => __( 'رنگ ایکون اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .title-left-403-farvardin-one' => 'color: {{VALUE}} !important',
				],
			]
           );  
		   
		         	   	 	   $this->add_control(
'color_farnam_11',
			[
				'label' => __( 'رنگ پس زمینه اصلی محصولات', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .chap-left-403-farvardin-twi' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   
		   
		          	   	 	   $this->add_control(
'color_farnam_12',
			[
				'label' => __( 'رنگ پس زمینه محصول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mr-402-box-product-403-farvardin-box42' => 'background: {{VALUE}} !important',
				],
			]
           );  
		   
		   
		   	          	   	 	   $this->add_control(
'color_farnam_14',
			[
				'label' => __( 'رنگ پس زمینه تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .daroffer-sepid-mobilewertetertws-mr-402-403-farvardin-box42' => 'background: {{VALUE}} !important',
					'{{WRAPPER}} .daroffer-sepid-mobilewertetertws-mr-402-403-farvardin-box42::before' => 'border-right-color: {{VALUE}} !important',
				],
			]
           );  
		          		 	   $this->add_control(
'color_farnam_16',
			[
				'label' => __( 'رنگ متن تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .daroffer-sepid-mobilewertetertws-mr-402-403-farvardin-box42' => 'color: {{VALUE}} !important',
				],
			]
           );     	 	   
		   		 	   $this->add_control(
'color_farnam_17',
			[
				'label' => __( 'رنگ عنوان محصول', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .title-product-flower-slider-one' => 'color: {{VALUE}} !important',
				],
			]
           );     

   $this->add_control(
'color_farnam_18',
			[
				'label' => __( 'رنگ پس زمینه قیمت تخفیف خورده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-403-farvardin-product-flower-slider-one del' => 'background: {{VALUE}} !important',
				],
			]
           );  

 $this->add_control(
'color_farnam_19',
			[
				'label' => __( 'رنگ متن قیمت تخفیف خورده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-403-farvardin-product-flower-slider-one del' => 'color: {{VALUE}} !important',
				],
			]
           );    		

 $this->add_control(
'color_farnam_20',
			[
				'label' => __( 'رنگ قیمت اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-403-farvardin-product-flower-slider-one' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .price-403-farvardin-product-flower-slider-one ins' => 'color: {{VALUE}} !important',
				],
			]
           );   
		   
		   
		    $this->add_control(
'color_farnam_20ew1',
			[
				'label' => __( 'رنگ پس زمینه دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .product-style.htpp.ir-owl.new-offer-401444545345fgteerrrmr-402 .owl-nav button' => 'background: {{VALUE}} !important',
				],
			]
           );   
  		    $this->add_control(
'color_farnam_20ew2',
			[
				'label' => __( 'رنگ ایکون دکمه اسلایدر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .product-style.htpp.ir-owl.new-offer-401444545345fgteerrrmr-402 .owl-nav button' => 'color: {{VALUE}} !important',
				],
			]
           );
		   	   	   $this->add_control(
                        'titr-124444-44r45rw',
                        [
                            'label' => __( 'سایه باکس محصول', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .mr-402-box-product-403-farvardin-box42',
			]
		);
				
			
				
				
		   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی باکس سمت راست', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .rast-right-403-farvardin-two' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

  $this->add_responsive_control(
                        'farnamborder2',
                        [
                            'label' => esc_html__( 'گردی باکس شمارنده', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .iran-pak-offer-farvardin-403-one .tarh-gaj-offer' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
				  $this->add_responsive_control(
                        'farnamborder3',
                        [
                            'label' => esc_html__( 'گردی ایکون عنوان', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .title-left-403-farvardin-one i' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
								  $this->add_responsive_control(
                        'farnamborder4',
                        [
                            'label' => esc_html__( 'گردی باکس اصلی محصولات', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .chap-left-403-farvardin-twi' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
									  $this->add_responsive_control(
                        'farnamborder5',
                        [
                            'label' => esc_html__( 'گردی باکس محصول', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mr-402-box-product-403-farvardin-box42' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
					$this->add_responsive_control(
                        'farnamborder6',
                        [
                            'label' => esc_html__( 'گردی تصویر محصول', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mini-product-add-to-crrra44rt-mr-tasvir-403-farvardin-box42 img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
					  $this->add_responsive_control(
                        'farnamborder7',
                        [
                            'label' => esc_html__( 'گردی تخفیف', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .daroffer-sepid-mobilewertetertws-mr-402-403-farvardin-box42' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
 $this->add_responsive_control(
                        'farnamborder8',
                        [
                            'label' => esc_html__( 'گردی قیمت تخفیف خورده', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .price-403-farvardin-product-flower-slider-one del' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
					$this->add_responsive_control(
                        'farnamborder99',
                        [
                            'label' => esc_html__( 'گردی دکمه اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .product-style.htpp.ir-owl.new-offer-401444545345fgteerrrmr-402 .owl-nav button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					
					
        $this->end_controls_section();


    }

    protected function render( $instance = [] ) {

        $settings           = $this->get_settings_for_display();
        $product_type       = $this->get_settings_for_display('woolentor_product_grid_product_filter');
        $per_page           = $this->get_settings_for_display('woolentor_product_grid_products_count');
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $order              = $this->get_settings_for_display('order');
        $columns            = $this->get_settings_for_display('woolentor_product_grid_column');
        $rows               = $this->get_settings_for_display('woolentor_product_grid_row');
        $tabuniqid          = $this->get_id();
        $proslider          = $this->get_settings_for_display('proslider');
        $producttab          = $this->get_settings_for_display('producttab');

        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $slider_settings = [
           
        ];

        $slider_responsive_settings = [
            
        ];

        $slider_settings = array_merge($slider_settings, $slider_responsive_settings);

        // WooCommerce Category
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $per_page,
        );

        switch( $product_type ){

                 case 'sale':
  $args['meta_key']   = '_sale_price';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;

            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'top_rated': 
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';          
            break;

            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;

            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby'] = $orderby;
            $args['order'] = $order;
        }

        $get_product_categories = $settings['woolentor_product_grid_categories']; // get custom field value
        $product_cats = str_replace(' ', '', $get_product_categories);

        if ( "0" != $get_product_categories) {
            if( is_array($product_cats) && count($product_cats) > 0 ){
                $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_cat',
                        'terms' => $product_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }

        $products = new \WP_Query( $args );

        $tabmenu = 'yes';

        if( ($proslider == 'yes') && ( $producttab != 'yes' ) ){
            $collumval = 'slide-item ht-col-xs-12';
        }else{
            $collumval = 'product-list-off-401aswhgmr402 hgtt4444444444444444';
            if( $columns !='' ){
                if( $columns == 5){
                    $collumval = 'product-list-off-401aswhgmr402 hgtt4444444444444444';
                }else{
                    $colwidth = round(12/$columns);
                    $collumval = 'ht-col-lg-'.$colwidth.'product-list-off-401aswhgmr402 hgtt4444444444444444';
                }
            }
        }

        ?>
          
        <div class="product-style htpp ir-owl new-offer-401444545345fgteerrrmr-402">

            <?php if ( $producttab == 'yes' ) { ?>
                <div class="product-tab-list ht-text-center4mr-402">
  
                    </ul>
                </div>
            <?php }; ?>

            <?php if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ): ?>
                
            <?php
                $j=0;
                foreach( $product_cats as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    $products = new \WP_Query( $args );
                    ?>
                
                <?php endforeach;?>

            <?php else:?>
			
			
			<div class="rast-right-403-farvardin-one">
						<div class="rast-right-403-farvardin-two">
						
						<svg xmlns="http://www.w3.org/2000/svg" version="1.0" width="195.000000pt" height="170.000000pt" viewBox="0 0 195.000000 170.000000" preserveAspectRatio="xMidYMid meet">

<g stroke="none">
<path style="opacity:0.996" fill="#fefffe" d="M -0.5,-0.5 C 64.5,-0.5 129.5,-0.5 194.5,-0.5C 194.5,-0.166667 194.5,0.166667 194.5,0.5C 172.077,2.75452 159.244,15.0879 156,37.5C 155.667,63.5 155.333,89.5 155,115.5C 152.833,121.667 148.667,125.833 142.5,128C 107.5,128.333 72.5,128.667 37.5,129C 14.7266,132.604 2.05991,145.771 -0.5,168.5C -0.5,112.167 -0.5,55.8333 -0.5,-0.5 Z"/>

</g>
</svg>
							<?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>

		<div class="iran-pak-offer-farvardin-403-one">
<span>زمان باقی مانده</span>

<i class="mdi mdi-timelapse"></i>
<div id="fmoffer<?php echo '' . $settings['code_slider'] . ''; ?>" class="tarh-gaj-offer"></div>
<script type="text/javascript">
  $("#fmoffer<?php echo '' . $settings['code_slider'] . ''; ?>")
  .countdown("<?php echo '' . $settings['zaman'] . ''; ?>", function(event) {
    $(this).text(
      event.strftime('%D:%H:%M:%S')
	
    );
  });
</script>
</div>
<?php } ?>

<?php if ( 'yes' === $settings['farnamoneshow3'] ) { ?><div class="buttom-234234-farvardin-403">

	<?php	echo '<img src="' . $settings['imageasl']['url'] . '">'; ?>
</div><?php } ?>
			</div>			</div>
			
						<div class="chap-left-403-farvardin-one">
<div class="title-left-403-farvardin-one">							
	<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>

<?php echo '' . $settings['widget_title'] . ''; ?></div>
</div>
                <div class="ht-row ns-402-197564876-000mr-402 fdd34234-farvardindr4">

			
	
                 <script>           $(document).ready(function(){
$('.owl-offer-new1254wmr-gol').owlCarousel({
    loop:true,
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
        margin:0,
    dots: false,
    responsive:{
        0:{
            items:1
        },
		   820:{
            items:2,
			        margin:0
        },
        1024:{
            items:3
        },
        1250:{
            items:4
        }
    }
})
});</script>

						<div class="chap-left-403-farvardin-twi">

   <div class="owl-offer-new1254wmr-gol owl-carousel">

                        <div class="<?php echo esc_attr( $collumval );?>">
                            <?php
                                $k=1;
                                if( $products->have_posts() ):
                                    while( $products->have_posts() ): $products->the_post();
                            ?>
							
							
							<div class="mr-402-box-product-403-farvardin-box42">

														<div class="mr-402-box-product-1-403-farvardin-box42">
											
							
							<div class="mini-product-add-to-crrra44rt-mr-tasvir-403-farvardin-box42">
							
			<a href="<?php the_permalink(); ?>">
							<?php the_post_thumbnail('woocommerce_thumbnail'); ?>
							
							
							<div class="title-product-flower-slider-one">
							<?php the_title(); ?>

							</div>
							<?php if ( 'yes' === $settings['farnamoneshow5'] ) { ?>
							<div class="price-403-farvardin-product-flower-slider-one">
							<?php global $product; echo $product->get_price_html(); ?>

							</div><?php } ?>
							
<?php if ( 'yes' === $settings['farnamoneshow4'] ) { ?>
	<?php global $product; if( $product->is_on_sale() ) { ?>

<div class="daroffer-sepid-mobilewertetertws-mr-402-403-farvardin-box42">
<?php echo apply_filters( 'woocommerce_sale_flashtwo', $product ); ?>

</div>
<?php } ?><?php } ?></a>
							</div>
							</div>
							</div>
				
							
							




                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
                            <div class="<?php echo esc_attr($collumval );?>">
                                <?php } $k++; endwhile; wp_reset_postdata();  endif; ?>
                            </div>
                    <?php if( $proslider == 'yes' ){ echo '</div>';} ?>
                </div>       </div>     </div>
            <?php endif;?>

        </div>  


        <?php

    }


}


