<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class pone7 extends Widget_Base {

    public function get_name() {
        return 'pone7';
    }
    
    public function get_title() {
        return __( 'محصولات شگفت انگیز 6', 'woolentor' );
    }

      public function get_icon() {
		return 'eicon eicon-bag-medium';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }

    public function get_script_depends() {
        return [
            'woolentor-widgets-scripts',
            'slick',
        ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'woolentor-products',
            [
                'label' => esc_html__( 'تنظیمات محصول', 'woolentor' ),
            ]
        );
        
            

            $this->add_control(
                'woolentor_product_grid_product_filter',
                [
                    'label' => esc_html__( 'فیلتر شده', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'recent',
                    'options' => [
                        'recent' => esc_html__( 'آخرین محصولات', 'woolentor' ),
                        'featured' => esc_html__( 'محضولات ویژه', 'woolentor' ),
                        'best_selling' => esc_html__( 'محصولات پر فروش', 'woolentor' ),
                        'sale' => esc_html__( 'محصولات تخفیفی', 'woolentor' ),
                        'top_rated' => esc_html__( 'محصولات محبوب', 'woolentor' ),
                    ],
                ]
            );
           
            $this->add_control(
              'woolentor_product_grid_row',
              [
                 'label'   => __( 'ستون ( فعلا فقط ۱ )', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 1,
                 'min'     => 1,
                 'max'     => 20,
                 'step'    => 1,
              ]
            );

            $this->add_control(
              'woolentor_product_grid_products_count',
              [
                 'label'   => __( 'تعداد محصولات', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 4,
                 'min'     => 1,
                 'max'     => 100,
                 'step'    => 1,
              ]
            );

            $this->add_control(
                'woolentor_product_grid_categories',
                [
                    'label' => esc_html__( 'دسته بندی محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => woolentor_woocommerce_product_categories(),
                ]
            );
           

           

        $this->end_controls_section();


        

                 $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );

		
		       $this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش قیمت', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش تایمر', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		       $this->add_control(
			'farnamoneshow3',
			[
				'label' => __( 'نمایش جعبه دسترسی سریع', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
        $this->end_controls_section();


        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             


$this->add_control(
'color_farnam_1',
			[
				'label' => __( 'رنگ پس زمینه درصد تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .owl-pone.retert4445.owl-carousel.owl-rtl.owl-loaded.owl-drag .mizany' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'color_farnam_2',
			[
				'label' => __( 'رنگ متن درصد تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
	
				'selectors' => [
					'{{WRAPPER}} .owl-pone.retert4445.owl-carousel.owl-rtl.owl-loaded.owl-drag .mizany' => 'color: {{VALUE}} !important',
				],
			]
           );
		   

		   
		   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی دور محصولات', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .product-list-1.ps1.mehr-iran-21' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

  $this->add_responsive_control(
                        'farnamborder2',
                        [
                            'label' => esc_html__( 'گردی دور درصد تخفیف', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .owl-pone.retert4445.owl-carousel.owl-rtl.owl-loaded.owl-drag .mizany' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
				  $this->add_responsive_control(
                        'farnamborder3',
                        [
                            'label' => esc_html__( 'گردی دور دکمه اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .roozaye-barfi .owl-nav button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
						
						  $this->add_responsive_control(
                        'farnamborder4',
                        [
                            'label' => esc_html__( 'گردی دور جعبه دسترسی سریع', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .nimche-21' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
						
								  $this->add_responsive_control(
                        'farnamborder5',
                        [
                            'label' => esc_html__( 'گردی ثانیه شمار', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mini-1-time' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
					
        $this->end_controls_section();


          



    }

    protected function render( $instance = [] ) {

        $settings           = $this->get_settings_for_display();
        $product_type       = $this->get_settings_for_display('woolentor_product_grid_product_filter');
        $per_page           = $this->get_settings_for_display('woolentor_product_grid_products_count');
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $order              = $this->get_settings_for_display('order');
        $columns            = $this->get_settings_for_display('woolentor_product_grid_column');
        $rows               = $this->get_settings_for_display('woolentor_product_grid_row');
        $tabuniqid          = $this->get_id();
        $proslider          = $this->get_settings_for_display('proslider');
        $producttab          = $this->get_settings_for_display('producttab');

        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $slider_settings = [
    
        ];

        $slider_responsive_settings = [
           

        ];

        $slider_settings = array_merge($slider_settings, $slider_responsive_settings);

        // WooCommerce Category
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $per_page,
        );

        switch( $product_type ){

            case 'sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
            break;

            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;

            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'top_rated': 
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';          
            break;

            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;

            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby'] = $orderby;
            $args['order'] = $order;
        }

        $get_product_categories = $settings['woolentor_product_grid_categories']; // get custom field value
        $product_cats = str_replace(' ', '', $get_product_categories);

        if ( "0" != $get_product_categories) {
            if( is_array($product_cats) && count($product_cats) > 0 ){
                $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_cat',
                        'terms' => $product_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }

        $products = new \WP_Query( $args );

        $tabmenu = 'yes';

        if( ($proslider == 'yes') && ( $producttab != 'yes' ) ){
            $collumval = 'slide-item ht-col-xs-12';
        }else{
            $collumval = 'product-list';
            if( $columns !='' ){
                if( $columns == 5){
                    $collumval = 'product-list';
                }else{
                    $colwidth = round(12/$columns);
                    $collumval = 'ht-col-lg-'.$colwidth.'product-list';
                }
            }
        }

        ?>
          
        <div class="ps2 product-style htpp">

            <?php if ( $producttab == 'yes' ) { ?>
                <div class="product-tab-list ht-text-center">
  
                    </ul>
                </div>
            <?php }; ?>

            <?php if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ): ?>
                
            <?php
                $j=0;
                foreach( $product_cats as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    $products = new \WP_Query( $args );
                    ?>
                
                <?php endforeach;?>

            <?php else:?>
                <div class="ht-row roozaye-barfi">
                 <script>
        $(document).ready(function(){
$('.owl-pone').owlCarousel({
    loop:true,
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
	dots:true,
        margin:10,
    dots: false,
    responsive:{
        0:{
            items:1
        },
        700:{
            items:3
        },
		   1200:{
            items:4
        },
        1250:{
            items:5
        }
    }
})
});
     </script>	 
   <div class="owl-pone retert4445 owl-carousel">

                        <div class="<?php echo esc_attr( $collumval );?>">
                            <?php
                                $k=1;
                                if( $products->have_posts() ):
                                    while( $products->have_posts() ): $products->the_post();
                            ?>
 <div class="ps1-1">

 <div class="product-list-1 ps1 mehr-iran-21">

<a href="<?php the_permalink(); ?>">
	<?php the_post_thumbnail('woocommerce_thumbnail'); ?>
<h3><?php the_title(); ?></h3>
</a>

<div class="list-meta">
<span class="list-meta-1 regtretert">
<div class="box-rating woocommerce" style="display:none;">
 <?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product;

if ( 'no' === get_option( 'woocommerce_enable_review_rating' ) ) {
	return;
}

$rating_count = $product->get_rating_count();
$review_count = $product->get_review_count();
$average      = $product->get_average_rating();

if ( $rating_count > 0 ) : ?>

	<div class="woocommerce-product-rating">
		<?php echo wc_get_rating_html( $average, $rating_count ); ?>
		<?php if ( comments_open() ) : ?><?php endif ?>
	</div>

<?php endif; ?>

</div>

</span> <?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>

<span class="list-meta-2 d5456546f">


<?php global $product; if( $product->is_on_sale() ) { ?>

<div class="mizany">
	<?php echo apply_filters( 'woocommerce_sale_flashtwo', $post, $product ); ?>


</div>
<?php } ?>
<div class="risk-meta-price-98">
<?php echo $product->get_price_html(); ?>
 <?php
				do_action( 'woocommerce_namojood' );
	?></div>
</span><?php } ?>

</span> <?php if ( 'yes' === $settings['farnamoneshow3'] ) { ?>

<div class="risk-meta hhgg-4445">
<div class="nimche-21">
<div class="liningk bazsho1">
<div class="tooltiping">
علاقه مندی به محصول</div>
<?php echo do_shortcode("[yith_wcwl_add_to_wishlist]"); ?>
</div>
<span class="cpmare-wefew bazsho1">
<div class="tooltiping">
مقایسه این محصول</div>
<?php echo do_shortcode( '[woosc id=' . get_the_ID() . ']' ); ?>
</span>

<span class="cpmare-wefew-1 bazsho1">
<div class="tooltiping">
مشاهده سریع محصول</div>
<?php echo do_shortcode( '[woosq id=' . get_the_ID() . ']' ); ?>
</span>



</div>
</div><?php } ?>

<?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>
<?php global $product;
								if(  $product->is_on_sale() && $product->is_type('variable')){
?>
							<?php
				    global $post;
 // Variation ID
   $date="";
		    $sc_saving_pric = "";
			$sc_english_format_number = "";
            foreach($product->get_available_variations() as $variation ){
            $variation_id = $variation['variation_id'];
			            $sales_price_tot = get_post_meta( $variation_id, '_sale_price_dates_to', true );

								if(  $product->is_on_sale() && $sales_price_tot != "" && $product->is_type('variable')){
									
									
     
					?>
<?php global $post;

if ( ! $available_variations ) {
?>

	<?php
						if( $product->is_on_sale() && ! is_admin() && ! $product->is_type('variable')){
										$available_variations = $product->get_available_variations();

						}
		elseif($product->is_type('variable')){
		    $date="";
		    $sc_saving_pric = "";
			$sc_english_format_number = "";
            foreach($product->get_available_variations() as $variation ){
            // Variation ID
            $variation_id = $variation['variation_id'];
        // Prices
        $active_price = floatval($variation['display_price']); // Active price
        $regular_price = floatval($variation['display_regular_price']); // Regular Price
        if( $active_price != $regular_price ){
            $sale_price = $active_price; // Sale Price

            $meta_date = get_post_meta( $variation_id, '_sale_price_dates_to', true );
 $date1  .= 'display: block;';
            $sc_saving_pric .= $regular_price - $active_price;
			$sc_english_format_number .= number_format($sc_saving_pric);
        }





        }
						}
						
						  global $product;
	
		 
    if( $product->is_type('variable') ){
        $default_attributes = $product->get_default_attributes();
        foreach($product->get_available_variations() as $variation_values ){
            foreach($variation_values['attributes'] as $key => $attribute_value ){
                $attribute_name = str_replace( 'attribute_', '', $key );
                $default_value = $product->get_variation_default_attribute($attribute_name);
                if( $default_value == $attribute_value ){
                    $is_default_variation = true;
                } else {
                    $is_default_variation = false;
                    break; // Stop this loop to start next main lopp
                }
            }
            if( $is_default_variation ){
                $variation_id = $variation_values['variation_id'];
                break; // Stop the main loop
		
            }
        }
		
		
        if( $is_default_variation ){
            // Raw output of available "default" variation details data
		 $meta_date = get_post_meta( $variation_id, '_sale_price_dates_to', true );
					if( empty( $meta_date ) ){
																//	echo esc_html_e( 'زمان بندی پیشنهاد ویژه تعیین نشده است!', 'studiare' );
															}
          	else{
					$date  = date( 'm/d/Y', $meta_date );//echo $date;
			}
		
								if( empty( $meta_date ) ){
								}
								else{
	
						   ?>
						   
						   
						   <div class="iran-pak in-offer-2 seven-ffer-iranin timer-hazfi9">
<div id="gf<?php echo get_the_ID(); ?>"></div>
<script type="text/javascript">
 $('#gf<?php echo get_the_ID(); ?>').countdown('<?php echo esc_attr( $date ) ?>', function(event) {
  var $this = $(this).html(event.strftime(''
    + '<div class="timer-wrapper"><div class="time1">%D</div><span class="text32">روز</span></div>'
    + '<div class="timer-wrapper"><div class="time1">%H</div><span class="text32">ساعت</span></div>'
    + '<div class="timer-wrapper"><div class="time1">%M</div><span class="text32">دقیقه</span></div>'
    + '<div class="timer-wrapper"><div class="time1 mini-1-time">%S</div><span class="text32">ثانیه</span></div>'
));
});
</script>

</div>


<?php }
			}
								}	}	}}}
					?>
  <?php
					global $post;

  $sales_price_to = get_post_meta($post->ID, '_sale_price_dates_to', true);
  

    if (  $sales_price_to != "" ) {      


 
					?>
					
					
<div class="iran-pak in-offer-2 seven-ffer-iranin">
<div id="gf<?php echo get_the_ID(); ?>"></div>
<script type="text/javascript">
 $('#gf<?php echo get_the_ID(); ?>').countdown('<?php echo do_shortcode( '[display_end_date]' ); ?>', function(event) {
  var $this = $(this).html(event.strftime(''
    + '<div class="timer-wrapper"><div class="time1">%D</div><span class="text32">روز</span></div>'
    + '<div class="timer-wrapper"><div class="time1">%H</div><span class="text32">ساعت</span></div>'
    + '<div class="timer-wrapper"><div class="time1">%M</div><span class="text32">دقیقه</span></div>'
    + '<div class="timer-wrapper"><div class="time1 mini-1-time">%S</div><span class="text32">ثانیه</span></div>'
));
});
</script>

</div><?php }
					
					?><?php } ?>
</div>

</div></div>


                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
                            <div class="<?php echo esc_attr($collumval );?>">
                                <?php } $k++; endwhile; wp_reset_postdata();  endif; ?>
                            </div>
                    <?php if( $proslider == 'yes' ){ echo '</div>';} ?>
                </div>    				</div>
            <?php endif;?>

        </div>  


        <?php

    }


}


