<?php
namespace Elementor;

class boxsingle extends Widget_Base {
	
	public function get_name() {
		return 'boxsingle';
	}
	
	public function get_title() {
		return 'خدمات مابا تصویر';
	}
	
 public function get_icon() {
		return 'eicon eicon-icon-box';
    }
    
    public function get_categories() {
        return [ 'farnamproduct' ];
    }

	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'محتوا', 'elementor' ),
			]
		);
		
	
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'عنوان', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'پرداخت با کارت بانکی', 'plugin-name' ),
				'placeholder' => esc_html__( 'یک عنوان وارد کنید', 'plugin-name' ),
			]
		);
	$this->add_control(
			'titleone',
			[
				'label' => esc_html__( 'زیر عنوان', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '100% رایگان برای ما', 'plugin-name' ),
				'placeholder' => esc_html__( 'یک عنوان وارد کنید', 'plugin-name' ),
			]
		);
		
		
			$this->add_control(
			'link',
			[
				'label' => esc_html__( 'لینک توضیحات بیشتر', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'plugin-name' ),
				'placeholder' => esc_html__( 'یک لینک وارد کنید', 'plugin-name' ),
			]
		);
	$this->add_control(
			'image',
			[
				'label' => esc_html__( 'انتخاب تصویر', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		
		$this->add_control(
			'show_timer',
			[
				'label' => __( 'نمایش توضیحات', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);


		$this->end_controls_section();
		
		
  $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );


		    $this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'پس زمینه تصویر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mike-single-box-img .mike-single-box-imgee' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		      $this->add_control(
                        'titr-mehr-4',
                        [
                            'label' => __( 'سایه دور تصویر', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );

			$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .mike-single-box-img .mike-single-box-imgee',
			]
		);
		
		      $this->add_control(
'sepidcolor-3',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mike-single-bix-imgg-title-1' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
  $this->add_control(
'sepidcolor-5fr1',
			[
				'label' => __( 'رنگ زیر عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mike-single-bix-imgg-title2' => 'color: {{VALUE}} !important',
				],
			]
           );


  $this->add_control(
'sepidcolor-5fr16',
			[
				'label' => __( 'رنگ پس زمینه ایکون اطلاعات بیشتر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mike-single-box-imgee .mdi.mdi-comment-question-outline' => 'background: {{VALUE}} !important',
				],
			]
           );
	
	 $this->add_control(
'sepidcolor-5fr17',
			[
				'label' => __( 'رنگ متن ایکون اطلاعات بیشتر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mike-single-box-imgee .mdi.mdi-comment-question-outline' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'sepidcolor-5fr18',
			[
				'label' => __( 'رنگ پس زمینه اطلاعات بیشتر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .tooltip-newsffsr4' => 'background: {{VALUE}} !important',
				],
			]
           );
		    $this->add_control(
'sepidcolor-5f554r18',
			[
				'label' => __( 'رنگ متن اطلاعات بیشتر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .tooltip-newsffsr4' => 'color: {{VALUE}} !important',
				],
			]
           );
		
		
					 $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mike-single-box-img .mike-single-box-imgee' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					 $this->add_responsive_control(
                        'sepidborder-28777',
                        [
                            'label' => esc_html__( 'گردی ایکون', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mike-single-box-imgee .mdi.mdi-comment-question-outline' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					
					 $this->add_responsive_control(
                        'sepidborder-2877777',
                        [
                            'label' => esc_html__( 'گردی باکس اطلاعات بیشتر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .tooltip-newsffsr4' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
		$this->end_controls_section();
		
	}
	protected function render() {
		$settings = $this->get_settings_for_display();


				?>
				
				
				<a 	<?php if ( 'yes' === $settings['show_timer'] ) { ?>href="<?php echo '' . $settings['link'] . ''; ?>"<?php }
						
					?>
 class="mike-single-box-img">
				<div class="mike-single-box-imgee">
			 <?php if ( 'yes' === $settings['show_timer'] ) { ?>
	<i class="mdi mdi-comment-question-outline">
	
<div class="tooltip-newsffsr4">
برای اطلاعات بیشتر کلیک کنید
</div>	
	
	</i>
	
	
	
	
	<?php }
						
					?>
			<?php echo '<img src="' . $settings['image']['url'] . '">'; ?>
				</div>
				<div class="mike-single-bix-imgg-title">				<div class="mike-single-bix-imgg-title-1">

				<?php echo '' . $settings['title'] . ''; ?>
</div>
				<div class="mike-single-bix-imgg-title2">
				<?php echo '' . $settings['titleone'] . ''; ?>


</div>
				</div>
				</a>

		<?php


	}


	
	protected function _content_template() {

    }
	
	
}