<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class poff extends Widget_Base {

    public function get_name() {
        return 'poff';
    }
    
    public function get_title() {
        return __( 'محصولات شگفت انگیز 1', 'woolentor' );
    }

    public function get_icon() {
		return 'eicon eicon-bag-medium';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }

    public function get_script_depends() {
        return [
            'woolentor-widgets-scripts',
            'slick',
        ];
    }

    protected function register_controls() {


        $this->start_controls_section(
            'woolentor-products',
            [
                'label' => esc_html__( 'تنظیمات محصول', 'woolentor' ),
            ]
        );
        
            

            $this->add_control(
                'woolentor_product_grid_product_filter',
                [
                    'label' => esc_html__( 'فيلتر شده', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'recent',
                    'options' => [
                        'recent' => esc_html__( 'آخرين محصولات', 'woolentor' ),
                        'featured' => esc_html__( 'محضولات ويژه', 'woolentor' ),
                        'best_selling' => esc_html__( 'محصولات پر فروش', 'woolentor' ),
                        'sale' => esc_html__( 'محصولات تخفيفي', 'woolentor' ),
                        'top_rated' => esc_html__( 'محصولات محبوب', 'woolentor' ),
                    ],
                ]
            );
           
            $this->add_control(
              'woolentor_product_grid_row',
              [
                 'label'   => __( 'ستون', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 1,
                 'min'     => 1,
                 'max'     => 1,
                 'step'    => 1,
              ]
            );

            $this->add_control(
              'woolentor_product_grid_products_count',
              [
                 'label'   => __( 'تعداد محصولات', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 4,
                 'min'     => 1,
                 'max'     => 100,
                 'step'    => 1,
              ]
            );

            $this->add_control(
                'woolentor_product_grid_categories',
                [
                    'label' => esc_html__( 'دسته بندي محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => woolentor_woocommerce_product_categories(),
                ]
            );
           

                   $this->end_controls_section();

		       $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );
		$this->add_control(
			'show_timer',
			[
				'label' => __( 'نمایش تایمر', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		       $this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش درصد فروش', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش قیمت', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
        $this->end_controls_section();


        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             


$this->add_control(
'color_farnam_1',
			[
				'label' => __( 'رنگ پس زمینه درصد تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .darsad' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'color_farnam_2',
			[
				'label' => __( 'رنگ متن درصد تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .darsad' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'color_farnam_3',
			[
				'label' => __( 'رنگ نوار درصد فروش', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .progress-bar-bamdad' => 'background: {{VALUE}} !important',
				],
			]
           );

		   $this->add_control(
'color_farnam_4',
			[
				'label' => __( 'رنگ درصد فروش', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .bamdad-darsad' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_responsive_control(
                        'farnamborder1',
                        [
                            'label' => esc_html__( 'گردی دور محصولات', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .product-list-1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );

  $this->add_responsive_control(
                        'farnamborder2',
                        [
                            'label' => esc_html__( 'گردی دور درصد تخفیف', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .darsad' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
				  $this->add_responsive_control(
                        'farnamborder3',
                        [
                            'label' => esc_html__( 'گردی دور دکمه اسلایدر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .ir-owl .owl-nav button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
						
        $this->end_controls_section();


    }

    protected function render( $instance = [] ) {

        $settings           = $this->get_settings_for_display();
        $product_type       = $this->get_settings_for_display('woolentor_product_grid_product_filter');
        $per_page           = $this->get_settings_for_display('woolentor_product_grid_products_count');
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $order              = $this->get_settings_for_display('order');
        $columns            = $this->get_settings_for_display('woolentor_product_grid_column');
        $rows               = $this->get_settings_for_display('woolentor_product_grid_row');
        $tabuniqid          = $this->get_id();
        $proslider          = $this->get_settings_for_display('proslider');
        $producttab          = $this->get_settings_for_display('producttab');

        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $slider_settings = [
           
        ];

        $slider_responsive_settings = [
            
        ];

        $slider_settings = array_merge($slider_settings, $slider_responsive_settings);

        // WooCommerce Category
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $per_page,
        );

        switch( $product_type ){

                 case 'sale':
  $args['meta_key']   = '_sale_price';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;

            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'top_rated': 
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';          
            break;

            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;

            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby'] = $orderby;
            $args['order'] = $order;
        }

        $get_product_categories = $settings['woolentor_product_grid_categories']; // get custom field value
        $product_cats = str_replace(' ', '', $get_product_categories);

        if ( "0" != $get_product_categories) {
            if( is_array($product_cats) && count($product_cats) > 0 ){
                $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_cat',
                        'terms' => $product_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }

        $products = new \WP_Query( $args );

        $tabmenu = 'yes';

        if( ($proslider == 'yes') && ( $producttab != 'yes' ) ){
            $collumval = 'slide-item ht-col-xs-12';
        }else{
            $collumval = 'product-list';
            if( $columns !='' ){
                if( $columns == 5){
                    $collumval = 'product-list';
                }else{
                    $colwidth = round(12/$columns);
                    $collumval = 'ht-col-lg-'.$colwidth.'product-list';
                }
            }
        }

        ?>
          
        <div class="product-style htpp ir-owl">

            <?php if ( $producttab == 'yes' ) { ?>
                <div class="product-tab-list ht-text-center">
  
                    </ul>
                </div>
            <?php }; ?>

            <?php if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ): ?>
                
            <?php
                $j=0;
                foreach( $product_cats as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    $products = new \WP_Query( $args );
                    ?>
                
                <?php endforeach;?>

            <?php else:?>
                <div class="ht-row ns-402-2">
                 <script>           $(document).ready(function(){
$('.owl-offer').owlCarousel({
    loop:true,
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
	dots:true,
        margin:10,
    dots: false,
    responsive:{
        0:{
            items:1
        },
        360:{
            items:2
        },
        1200:{
            items:4
        }
    }
})
});</script>
   <div class="owl-offer owl-carousel">

                        <div class="<?php echo esc_attr( $collumval );?>">
                            <?php
                                $k=1;
                                if( $products->have_posts() ):
                                    while( $products->have_posts() ): $products->the_post();
                            ?>
<div class="product-list-1 ps1 niaz-1">

<a  href="<?php the_permalink(); ?>">
		<?php the_post_thumbnail('woocommerce_thumbnail'); ?>

<h3><?php the_title(); ?></h3>
</a>


<div class="list-meta">
 <?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>

<span class="list-meta-2">


	<?php
					global $product;
							if( $product->is_on_sale() ) {



				
					?>

<div class="darsad">
	<?php echo apply_filters( 'woocommerce_sale_flashtwo' , $product ); ?>


</div>
<?php }
						
					?>
<?php global $product; echo $product->get_price_html(); ?>
</span><?php }
						
					?>
</div>

 <?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>

<div class="ee49">
				<?php farnam_stock_progress_bar(); ?>
</div><?php }
						
					?>
 <?php if ( 'yes' === $settings['show_timer'] ) { ?>

<div class="paiin-11">
				<style>
				.iran-pak .timer-hazfi99 {
					display: none;
				}
				
			.iran-pak .timer-hazfi99:nth-child(1) {
	display: block !important;
}
				</style>

<div class="iran-pak">
  <div class="iran-pak" style="min-height: 24px; font-size: 15px;
font-weight: 400;">
 
	
           <?php 
		   
		   
		   
		   
		   global $post;
								if(  $product->is_on_sale() && $product->is_type('variable')){
					

	

							
		 
    if( $product->is_type('variable') ){
        $default_attributes = $product->get_default_attributes();
        foreach($product->get_available_variations() as $variation_values ){
            foreach($variation_values['attributes'] as $key => $attribute_value ){
                $attribute_name = str_replace( 'attribute_', '', $key );
                $default_value = $product->get_variation_default_attribute($attribute_name);
                if( $default_value == $attribute_value ){
                    $is_default_variation = true;
                } else {
                    $is_default_variation = false;
                    break; // Stop this loop to start next main lopp
                }
            }
            if( $is_default_variation ){
                $variation_id = $variation_values['variation_id'];
                break; // Stop the main loop
		
            }
        }

global $product;

if ($product->is_on_sale() && $product->is_type('variable') ) {
    $default_variation_id = 0;
    $default_variation = $product->get_available_variations()[0];
    if (is_a($default_variation, 'WC_Product_Variation')) {
        $variation_id = $default_variation->get_variation_id_by_sku($default_variation->get_sku());
    }
	
if ($product->is_on_sale() && $product->is_type('variable')) {
    global $product;

    $variation_id = null;

    if ($product->is_type('variable')) {
        $default_attributes = $product->get_default_attributes();
        foreach ($product->get_available_variations() as
 
$variation_values) {
            foreach ($variation_values['attributes'] as
 
$key => $attribute_value) {
                $attribute_name = str_replace('attribute_', '', $key);
                $default_value = $product->get_variation_default_attribute($attribute_name);

                if ($default_value == $attribute_value) {
                    $variation_id = $variation_values['variation_id'];
                    break 2; // Exit both loops
                }
            }
        }
    }

    if ($variation_id) {
        $sale_end_date = get_post_meta($variation_id, '_sale_price_dates_to', true);
    } else {
        // Variation is not selected, so don't display anything
    }
}
    if (empty($sale_end_date) || $sale_end_date < current_time('timestamp')) {
								        // چیزی نمایش داده نمیشود
    } else {
        // The discount is still active
 

        // Now we get the default variation data
        if( $is_default_variation ){
            // Raw output of available "default" variation details data
		 $meta_date = get_post_meta( $variation_id, '_sale_price_dates_to', true );
					if( empty( $meta_date ) ){
																//	echo esc_html_e( 'زمان بندی پیشنهاد ویژه تعیین نشده است!', 'studiare' );
															}
          	else{
					$date  = date( 'm/d/Y 23:59', $meta_date );//echo $date;
			
			
			?>
			
			
			
			<div class="timer-hazfi99">
<i class="mdi mdi-timelapse"></i>
<div id="fm<?php echo get_the_ID(); ?>"></div>
<script type="text/javascript">
  $("#fm<?php echo get_the_ID(); ?>")
  .countdown("<?php echo esc_attr( $date ) ?>", function(event) {
    $(this).text(
      event.strftime('%D:%H:%M:%S')
	
    );
  });
</script></div>



			<?php
          	}		

   


								}
								else {
								        // چیزی نمایش داده نمیشود
	
									
								}
			}
					   }
}			
									}
								
								else {
									
							



  $sales_price_to = get_post_meta($post->ID, '_sale_price_dates_to', true);
															if( empty( $meta_date ) ){
																//	echo esc_html_e( 'زمان بندی پیشنهاد ویژه تعیین نشده است!', '' );
															}
					else{
					// $date  = date_i18n( 'm/d/Y', $meta_date );
					}
					
					
					
 $sale_end_date = get_post_meta($product->get_id(), '_sale_price_dates_to', true);
  if ($sale_end_date < current_time('timestamp')) {
    // تخفیف به پایان رسیده است، بنابراین تایمر را نمایش ندهید
  } else {
	  global $post;


					$date  = date( 'm/d/Y 23:59', $sales_price_to );//echo $date;


?>




											<div class="timer-hazfi99">
<i class="mdi mdi-timelapse"></i>
<div id="fm<?php echo get_the_ID(); ?>"></div>
<script type="text/javascript">
  $("#fm<?php echo get_the_ID(); ?>")
  .countdown("<?php echo esc_attr( $date ) ?>", function(event) {
    $(this).text(
      event.strftime('%D:%H:%M:%S')
	
    );
  });
</script></div><?php
								}}
								

  
?>


			
			
</div>

</div>
					
					</div> <?php } ?>
</div>

                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
                            <div class="<?php echo esc_attr($collumval );?>">
                                <?php } $k++; endwhile; wp_reset_postdata();  endif; ?>
                            </div>
                    <?php if( $proslider == 'yes' ){ echo '</div>';} ?>
                </div>       </div>
            <?php endif;?>

        </div>  


        <?php

    }


}


