<?php
namespace Elementor;

class blogtwo extends Widget_Base {
	
	public function get_name() {
		return 'blogtwo';
	}
	
	public function get_title() {
		return 'وبلاگ - اسلایدر مطالب';
	}
	
		
    public function get_icon() {
		return 'eicon eicon-posts-group';
    }
    
    public function get_categories() {
        return [ 'farnam' ];
    }
	
	protected function register_controls() {

		$post_cat = array();
		$categories = get_terms("category");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		


		
		$this->add_control(
			'title',
			[
				'label' => 'عنوان',
				'label_block' => true,
				'default' => 'مطالب',
				'type' => Controls_Manager::TEXT,
				'placeholder' => 'عنوان را وارد نمایید',
			]
		);

		$this->add_control(
			'post_sort',
			[
				'label' => 'مرتب سازی مطالب',
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => 'آخرین مطالب',
					'random' => 'مطالب تصادفی',
					'viewed' => 'مطالب پربازدید',
				],
			]
		);

		$this->add_control(
			'post_cat',
			[
				'label' => 'دسته بندی مطالب',
				'type' => Controls_Manager::SELECT2,
				'options' => $post_cat,
			]
		);




		$this->add_control(
			'ptotalcount',
			[
				'label' => 'تعداد مطالب',
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 20,
				'step' => 1,
				'default' => 8,
			]
		);

$this->add_responsive_control(
                        'farnam-border66-1',
                        [
                            'label' => esc_html__( 'گردی کادر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .blog-2021-b-1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
							$this->add_responsive_control(
                        'farnam-border66665-1',
                        [
                            'label' => esc_html__( 'گردی موضوع', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .blog-2021-b-2 .rang-201-2' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
								$this->add_responsive_control(
                        'farnam-border66665-2',
                        [
                            'label' => esc_html__( 'گردی تصویر نویسنده', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .blog-2021-b-2 .blog-2021-3 img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					
					$this->add_control(
			'colorone-tarikh',
			[
				'label' => __( 'رنگ تاریخ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .blog-2021-b-2 .blog-2021-3 .blog-2021-5' => 'color: {{VALUE}} !important',

				],
			]
		);
							$this->add_control(
			'colorone-nevisande',
			[
				'label' => __( 'رنگ نویسنده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .blog-2021-b-2 .blog-2021-3 h5' => 'color: {{VALUE}} !important',

				],
			]
		);
									$this->add_control(
			'colorone-nevisande1',
			[
				'label' => __( 'رنگ کادر زیر عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-vat-z12 h3::before' => 'background: {{VALUE}} !important',

				],
			]
		);
		     $this->add_control(
                        'titr-12-256566-9',
                        [
                            'label' => __( 'فعال سازی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );

				$this->add_control(
			'showineo1',
			[
				'label' => __( 'نمایش موضوع نوشته', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
				$this->add_control(
			'showineo2',
			[
				'label' => __( 'نمایش زمان مطالعه', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);


		$this->add_control(
			'showineo3',
			[
				'label' => __( 'نمایش نام نویسنده', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
				$this->add_control(
			'showineo4',
			[
				'label' => __( 'نمایش تاریخ نوشته', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->end_controls_section();
	}
	
	protected function render() {
		global $az_data;
		$settings = $this->get_settings_for_display();
		$post_cat = $settings['post_cat']; ?>
        <div class="rcon">
			<div class="post-block m-product ir99">
		
			<?php
			$post_sort = $settings['post_sort'];
				switch ($post_sort) {
					case 'latest':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
						break;
					case 'viewed':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'meta_key' => 'post_views_count',
						'orderby' => 'meta_value_num',
						'order' => 'DESC'  );
						break;
					case 'random':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'orderby'        => 'rand'  );
						break;
					default:
					$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
					}
					if ( $post_cat ) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'category',
							'field' => 'term_id',
							'terms' => $post_cat
							)
						);
					}
				$postsquery = new \WP_Query( $args );
			?>
			
			<?php if ( $postsquery->have_posts() ) { ?>

			<script>
			
			   $(document).ready(function(){
$('.owl-blogone').owlCarousel({
    loop:true,
     autoplay:true,
    autoplayTimeout:7000,
    autoplayHoverPause:true,
    rtl: true,
    nav:true,
	dots:true,
        margin:10,
    dots: false,
    responsive:{
        0:{
            items:1
        },
        850:{
            items:3
        },
        1200:{
            items:4
        }
    }
})
});

</script>
		                   <div class="owl-blogone owl-carousel bxboxone">

			<?php while ( $postsquery->have_posts() ) : $postsquery->the_post(); ?>
<div class="blog-2021-b-2">

<a class="blog-2021-b-1" href="<?php the_permalink(); ?>"  style="background: url(<?php echo $post_thumb = get_the_post_thumbnail_url( get_the_ID(), 'full' ); ?>)
;">
 <?php if ( 'yes' === $settings['showineo1'] ) { ?>

<?php $option_meta = rwmb_meta('mozo'); if (!empty($option_meta)) { ?>
<div class="rang-201-2" style="background: <?php $option_meta = rwmb_meta('mozocolor'); if (!empty($option_meta)) { ?>
<?php echo $option_meta; ?>
<?php } ?>;">
<?php $option_meta = rwmb_meta('mozo'); if (!empty($option_meta)) { ?>
<?php echo $option_meta; ?><?php } ?></div>
<?php } ?>

	   		<?php } ?> 

<div class="box-vat-z12">
<h3><?php the_title(); ?></h3>

 <?php if ( 'yes' === $settings['showineo2'] ) { ?>

<?php $option_meta = rwmb_meta('shoghl'); if (!empty($option_meta)) { ?>
 <div class="blog-meta-user dfgttyret">
 <span><i class="mdi mdi-timer"></i>
<?php echo $option_meta; ?>
 دقیقه زمان برای مطالعه</span>
 </div><?php } ?><?php } ?>

</div>
</a>

<div class="blog-2021-3">
 <?php if ( 'yes' === $settings['showineo3'] ) { ?>

<span class="blog-2021-4">
<?php
// Get author ID
$author_id = get_the_author_meta('ID');

// Get attachment ID
$avatar_attachment_id = get_user_meta($author_id, 'avatar', true);

// Get default avatar URL
$default_avatar_url = get_template_directory_uri() . '/img/user.jpg';

// Display author avatar
if ($avatar_attachment_id) {
  // Get image URL
  $avatar_url = wp_get_attachment_url($avatar_attachment_id);
  if ($avatar_url) {
    echo '<img src="' . esc_url($avatar_url) . '" alt="Author Avatar" width="100" height="100">';
  } else {
    // Display default avatar
    echo '<img src="' . esc_url($default_avatar_url) . '" alt="Default Avatar" width="100" height="100">';
  }
} else {
  // Display default avatar
  echo '<img src="' . esc_url($default_avatar_url) . '" alt="Default Avatar" width="100" height="100">';
}
?>
<h5><?php echo get_the_author_meta('display_name'); ?> </h5>

</span><?php } ?>
 <?php if ( 'yes' === $settings['showineo4'] ) { ?>

<span class="blog-2021-5">
<?php the_time('d M Y'); ?>
</span><?php } ?>
</div>
</div>
			<?php endwhile; ?>
				</div>
			<?php 
			} else {		
			echo 'لطفا ابتدا نوشته ای را اضافه نمایید.';}
			wp_reset_postdata();
			?>
			</div>
   		</div>
        <?php

	}

}